/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.converter.nwb_graphstream;

import edu.iu.cns.graphstream.common.AnnotatedGraph;
import edu.iu.cns.graphstream.common.Utilities;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;

public class GraphStreamToNWBAlgorithm
implements Algorithm {
    public static final String OUTPUT_FILE_BASE_NAME = "graphstream_to_nwb-";
    public static final String NWB_MIME_TYPE = "file:text/nwb";
    public static final String OUT_LABEL = "Converted to NWB";
    private Data inputData;
    private AnnotatedGraph inputGraph;

    public GraphStreamToNWBAlgorithm(Data inputData, AnnotatedGraph inputGraph) {
        this.inputData = inputData;
        this.inputGraph = inputGraph;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            File outputFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)OUTPUT_FILE_BASE_NAME, (String)"nwb");
            NWBFileWriter nwbWriter = new NWBFileWriter(outputFile);
            this.writeNodes(nwbWriter);
            this.writeDirectedEdges(nwbWriter);
            this.writeUndirectedEdges(nwbWriter);
            return this.wrapGraphAsOutputData(outputFile);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void writeNodes(NWBFileWriter nwbWriter) {
        nwbWriter.setNodeSchema(this.inputGraph.getNodeSchema());
        Iterator nodes = this.inputGraph.getNodeIterator();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            String nodeID = node.getId();
            int id = Integer.parseInt(nodeID);
            nwbWriter.addNode(id, this.inputGraph.getNodeLabel(nodeID), Utilities.getElementAttributes((Element)node));
        }
    }

    private void writeDirectedEdges(NWBFileWriter nwbWriter) {
        this.setDirectedEdgeSchema(nwbWriter);
        Iterator edges = this.inputGraph.getEdgeIterator();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            int node1ID = Integer.parseInt(edge.getNode0().getId());
            int node2ID = Integer.parseInt(edge.getNode1().getId());
            Map attributes = Utilities.getElementAttributes((Element)edge);
            if (!edge.isDirected()) continue;
            nwbWriter.addDirectedEdge(node1ID, node2ID, attributes);
        }
    }

    private void writeUndirectedEdges(NWBFileWriter nwbWriter) {
        this.setUndirectedEdgeSchema(nwbWriter);
        Iterator edges = this.inputGraph.getEdgeIterator();
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            int node1ID = Integer.parseInt(edge.getNode0().getId());
            int node2ID = Integer.parseInt(edge.getNode1().getId());
            Map attributes = Utilities.getElementAttributes((Element)edge);
            if (edge.isDirected()) continue;
            nwbWriter.addUndirectedEdge(node1ID, node2ID, attributes);
        }
    }

    private void setDirectedEdgeSchema(NWBFileWriter nwbWriter) {
        LinkedHashMap directedEdgeSchema = this.inputGraph.getDirectedEdgeSchema();
        if (directedEdgeSchema != null) {
            nwbWriter.setDirectedEdgeSchema(directedEdgeSchema);
        }
    }

    private void setUndirectedEdgeSchema(NWBFileWriter nwbWriter) {
        LinkedHashMap undirectedEdgeSchema = this.inputGraph.getUndirectedEdgeSchema();
        if (undirectedEdgeSchema != null) {
            nwbWriter.setUndirectedEdgeSchema(undirectedEdgeSchema);
        }
    }

    private Data[] wrapGraphAsOutputData(File outputFile) {
        BasicData outputNWBFileData = new BasicData((Object)outputFile, NWB_MIME_TYPE);
        Dictionary outputNWBFileMetadata = outputNWBFileData.getMetadata();
        outputNWBFileMetadata.put("Label", OUT_LABEL);
        outputNWBFileMetadata.put("Parent", this.inputData);
        outputNWBFileMetadata.put("Type", "Network");
        return new Data[]{outputNWBFileData};
    }
}

