/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.converter.nwb_graphstream;

import edu.iu.cns.converter.nwb_graphstream.NWBIntoAnnotatedGraphFileParser;
import edu.iu.cns.graphstream.common.AnnotatedGraph;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class NWBToGraphStreamAlgorithm
implements Algorithm {
    public static final String OUT_LABEL = "Converted to GraphStream";
    private Data inputData;
    private File nwbFile;

    public NWBToGraphStreamAlgorithm(Data inputData, File nwbFile) {
        this.inputData = inputData;
        this.nwbFile = nwbFile;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            NWBIntoAnnotatedGraphFileParser converter = new NWBIntoAnnotatedGraphFileParser();
            NWBFileParser nwbParser = new NWBFileParser(this.nwbFile);
            nwbParser.parse((NWBFileParserHandler)converter);
            AnnotatedGraph graph = converter.getGraph();
            return this.wrapGraphAsOutputData(graph);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] wrapGraphAsOutputData(AnnotatedGraph graph) {
        BasicData outputGraphData = new BasicData((Object)graph, graph.getClass().getName());
        Dictionary outputGraphMetadata = outputGraphData.getMetadata();
        outputGraphMetadata.put("Label", OUT_LABEL);
        outputGraphMetadata.put("Parent", this.inputData);
        outputGraphMetadata.put("Type", "Network");
        return new Data[]{outputGraphData};
    }
}

