/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.converter.csv_to_plot;

import au.com.bytecode.opencsv.CSVReader;
import edu.iu.cns.converter.csv_to_plot.exceptiontypes.CSVFileReadingException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.cishell.utilities.FileUtilities;
import org.cishell.utilities.StringUtilities;
import org.osgi.service.log.LogService;

public class CSVFileConverter {
    public static final String DEFAULT_COLUMN_NAME_PREFIX = "column";
    public static final String BASE_TEMPORARY_FILE_NAME = "csv_to_plot-";

    public static File convertCSVFileToPlotFile(File csvFile, LogService logger) throws IOException, CSVFileReadingException {
        CSVReader csvFileReader = new CSVReader((Reader)new FileReader(csvFile));
        try {
            String[] firstRow = csvFileReader.readNext();
            if (firstRow != null) {
                String[] header = CSVFileConverter.extractHeaderFromFirstRow(firstRow);
                File plotFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)BASE_TEMPORARY_FILE_NAME, (String)"plot");
                BufferedWriter plotFileWriter = new BufferedWriter(new FileWriter(plotFile));
                CSVFileConverter.writeHeader(plotFileWriter, header);
                csvFileReader.readNext();
                plotFileWriter.close();
                return plotFile;
            }
            String emptyCSVFileExceptionMessage = "The CSV file \"" + csvFile.getAbsolutePath() + "\" is empty.";
            throw new CSVFileReadingException(emptyCSVFileExceptionMessage);
        }
        catch (FileNotFoundException csvFileNotFoundException) {
            String exceptionMessage = "The CSV file \"" + csvFile.getAbsolutePath() + "\" could not be found.";
            throw new CSVFileReadingException(exceptionMessage, csvFileNotFoundException);
        }
    }

    private static String[] extractHeaderFromFirstRow(String[] firstRow) {
        try {
            int ii = 0;
            while (ii < firstRow.length) {
                Double.parseDouble(firstRow[ii]);
                ++ii;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return firstRow;
        }
        return CSVFileConverter.constructDefaultHeader(firstRow.length);
    }

    private static String[] constructDefaultHeader(int headerLength) {
        String[] defaultHeader = new String[headerLength];
        int ii = 0;
        while (ii < defaultHeader.length) {
            defaultHeader[ii] = DEFAULT_COLUMN_NAME_PREFIX + ii;
            ++ii;
        }
        return defaultHeader;
    }

    private static void writeHeader(BufferedWriter writer, String[] header) throws IOException {
        writer.write("# " + StringUtilities.implodeStringArray((String[])header, (String)" | "));
        writer.newLine();
    }

    private static void writeRow(BufferedWriter writer, String[] row) throws IOException {
        writer.write(StringUtilities.implodeStringArray((String[])row, (String)" "));
        writer.newLine();
    }
}

