/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.converter.csv_to_plot;

import edu.iu.cns.converter.csv_to_plot.CSVFileConverter;
import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class CSVToPlotConverterAlgorithm
implements Algorithm {
    public static final String OUT_LABEL = "as table";
    public static final String PLOT_MIME_TYPE = "file:text/plot";
    private Data inData;
    private File inFile;
    private LogService logger;

    public CSVToPlotConverterAlgorithm(Data[] data, Dictionary parameters, CIShellContext ciShellContext) {
        this.inData = data[0];
        this.inFile = (File)this.inData.getData();
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            File plotFile = CSVFileConverter.convertCSVFileToPlotFile(this.inFile, this.logger);
            return this.wrapTableForOutput(plotFile);
        }
        catch (Exception csvFileToPlotFileConversionException) {
            String exceptionMessage = "Could not convert .csv file \"" + this.inFile.getAbsolutePath() + "\" to .plot file.";
            throw new AlgorithmExecutionException(exceptionMessage, (Throwable)csvFileToPlotFileConversionException);
        }
    }

    private Data[] wrapTableForOutput(File outTable) {
        BasicData outData = new BasicData((Object)outTable, PLOT_MIME_TYPE);
        Dictionary outMetadata = outData.getMetadata();
        outMetadata.put("Label", OUT_LABEL);
        outMetadata.put("Parent", this.inData);
        outMetadata.put("Type", "Plot");
        return new Data[]{outData};
    }
}

