/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.converter.plot_to_csv;

import au.com.bytecode.opencsv.CSVWriter;
import edu.iu.cns.converter.plot_to_csv.exceptiontypes.PlotFileReadingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Scanner;
import org.cishell.utilities.FileUtilities;

public class PlotFileConverter {
    public static final String UNROUNDED_DECIMAL_PATTERN = "#.############################";
    public static final String PIPE_DELIMITER_PATTERN = "\\s*\\|\\s*";
    public static final String COMMENT_MARKER_PATTERN = "\\s*#+\\s*";
    public static final String CSV_FILE_EXTENSION = "csv";
    public static final String ONE_OR_MORE_WHITESPACES_PATTERN = "\\s+";
    public static final String STARTS_WITH_POUND_SIGN_PATTERN = "#.*";
    public static final String DEFAULT_COLUMN_NAME_PREFIX = "column";
    public static final String BASE_TEMPORARY_FILE_NAME = "plot_to_csv-";
    public static final String NOT_A_NUMBER_PREFIX = "NOT A NUMBER";

    public static File convertPlotFileToCSVFile(File plotFile) throws IOException, PlotFileReadingException {
        try {
            String[] plotFileHeader = PlotFileConverter.readHeader(plotFile);
            File csvFile = PlotFileConverter.convertPlotFile(plotFile, plotFileHeader);
            return csvFile;
        }
        catch (FileNotFoundException plotFileNotFoundException) {
            String exceptionMessage = "The plot file \"" + plotFile.getAbsolutePath() + "\" could not be found.";
            throw new PlotFileReadingException(exceptionMessage, plotFileNotFoundException);
        }
    }

    private static String[] readHeader(File plotFile) throws FileNotFoundException, IOException, PlotFileReadingException {
        BufferedReader plotFileReader = new BufferedReader(new FileReader(plotFile));
        String[] header = null;
        String line = null;
        try {
            try {
                line = plotFileReader.readLine();
                boolean lookingForHeader = true;
                while (lookingForHeader) {
                    if (line == null) {
                        lookingForHeader = false;
                        continue;
                    }
                    if (PlotFileConverter.lineIsComment(line)) {
                        if (!PlotFileConverter.commentLineIsEmpty(line)) {
                            header = PlotFileConverter.splitLineAsHeader(line);
                        }
                        line = plotFileReader.readLine();
                        continue;
                    }
                    if (PlotFileConverter.lineIsBlank(line)) {
                        line = plotFileReader.readLine();
                        continue;
                    }
                    lookingForHeader = false;
                }
            }
            catch (IOException lineReadingException) {
                throw new PlotFileReadingException(lineReadingException);
            }
        }
        finally {
            plotFileReader.close();
        }
        if (header != null) {
            if (line != null) {
                String[] defaultHeader = PlotFileConverter.constructDefaultHeaderFromDataLine(line);
                if (header.length == defaultHeader.length) {
                    return header;
                }
                return defaultHeader;
            }
            return header;
        }
        if (line != null) {
            return PlotFileConverter.constructDefaultHeaderFromDataLine(line);
        }
        String exceptionMessage = "The plot file \"" + plotFile.getAbsolutePath() + "\" is empty.  No CSV file can be created from it.";
        throw new PlotFileReadingException(exceptionMessage);
    }

    private static File convertPlotFile(File plotFile, String[] plotFileHeader) throws FileNotFoundException, IOException, PlotFileReadingException {
        BufferedReader plotFileReader = new BufferedReader(new FileReader(plotFile));
        File csvFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)BASE_TEMPORARY_FILE_NAME, (String)CSV_FILE_EXTENSION);
        CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(csvFile));
        csvWriter.writeNext(plotFileHeader);
        try {
            try {
                String line = plotFileReader.readLine();
                while (line != null) {
                    if (!PlotFileConverter.lineIsComment(line) && !PlotFileConverter.lineIsBlank(line)) {
                        String[] tokens = PlotFileConverter.splitLineAsData(line);
                        csvWriter.writeNext(tokens);
                    }
                    line = plotFileReader.readLine();
                }
            }
            catch (IOException lineReadingException) {
                throw new PlotFileReadingException(lineReadingException);
            }
        }
        finally {
            csvWriter.close();
        }
        return csvFile;
    }

    private static boolean lineIsComment(String line) {
        Scanner lineScanner = new Scanner(line);
        return lineScanner.hasNext(STARTS_WITH_POUND_SIGN_PATTERN);
    }

    private static boolean lineIsBlank(String line) {
        return !new Scanner(line).hasNext();
    }

    private static boolean commentLineIsEmpty(String line) {
        String[] splitLine = PlotFileConverter.splitLineAsHeader(line);
        return splitLine.length == 0;
    }

    private static String[] constructDefaultHeaderFromDataLine(String line) {
        String[] tokensInLine = PlotFileConverter.splitLineAsData(line);
        String[] defaultHeader = new String[tokensInLine.length];
        int ii = 0;
        while (ii < defaultHeader.length) {
            defaultHeader[ii] = DEFAULT_COLUMN_NAME_PREFIX + ii;
            ++ii;
        }
        return defaultHeader;
    }

    private static String[] splitLineAsHeader(String originalLine) {
        Scanner tokenizer = new Scanner(originalLine);
        tokenizer.skip(COMMENT_MARKER_PATTERN);
        if (tokenizer.hasNext()) {
            String commentContents = tokenizer.nextLine();
            if (commentContents.indexOf("|") != -1) {
                return commentContents.split(PIPE_DELIMITER_PATTERN);
            }
            return commentContents.split(ONE_OR_MORE_WHITESPACES_PATTERN);
        }
        return new String[0];
    }

    private static String[] splitLineAsData(String line) {
        Scanner tokenizer = new Scanner(line);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasNext()) {
            tokens.add(PlotFileConverter.convertToDecimalNotation(tokenizer.next()));
        }
        return tokens.toArray(new String[0]);
    }

    private static String convertToDecimalNotation(String numberAsString) {
        if (numberAsString.indexOf("E") != -1 || numberAsString.indexOf("e") != -1) {
            DecimalFormat format = new DecimalFormat(UNROUNDED_DECIMAL_PATTERN);
            try {
                return format.format(new Double(numberAsString));
            }
            catch (NumberFormatException numberFormatException) {
                return "NOT A NUMBER (" + numberAsString + ")";
            }
        }
        return numberAsString;
    }
}

