/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.graphstream.common;

import edu.iu.cns.graphstream.common.Utilities;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;

public class AnnotatedGraph
extends MultiGraph {
    private LinkedHashMap<String, String> nodeSchema;
    private LinkedHashMap<String, String> directedEdgeSchema;
    private LinkedHashMap<String, String> undirectedEdgeSchema;
    private Map<String, String> nodeLabelsByNodeID = new HashMap<String, String>();

    public AnnotatedGraph() {
    }

    public AnnotatedGraph(boolean strictChecking, boolean autoCreate) {
        super(strictChecking, autoCreate);
    }

    public AnnotatedGraph(String id) {
        super(id);
    }

    public AnnotatedGraph(String id, boolean strictChecking, boolean autoCreate) {
        super(id, strictChecking, autoCreate);
    }

    public AnnotatedGraph(AnnotatedGraph copyFrom) {
        this.setupFrom(copyFrom);
    }

    public AnnotatedGraph(AnnotatedGraph copyFrom, boolean strictChecking, boolean autoCreate) {
        super(strictChecking, autoCreate);
        this.setupFrom(copyFrom);
    }

    public AnnotatedGraph(AnnotatedGraph copyFrom, String id) {
        super(id);
        this.setupFrom(copyFrom);
    }

    public AnnotatedGraph(AnnotatedGraph copyFrom, String id, boolean strictChecking, boolean autoCreate) {
        super(id, strictChecking, autoCreate);
        this.setupFrom(copyFrom);
    }

    public LinkedHashMap<String, String> getNodeSchema() {
        return this.nodeSchema;
    }

    public LinkedHashMap<String, String> getDirectedEdgeSchema() {
        return this.directedEdgeSchema;
    }

    public LinkedHashMap<String, String> getUndirectedEdgeSchema() {
        return this.undirectedEdgeSchema;
    }

    public String getNodeLabel(String nodeID) {
        return this.nodeLabelsByNodeID.get(nodeID);
    }

    public void setNodeSchema(LinkedHashMap<String, String> nodeSchema) {
        this.nodeSchema = nodeSchema;
    }

    public void setDirectedEdgeSchema(LinkedHashMap<String, String> directedEdgeSchema) {
        this.directedEdgeSchema = directedEdgeSchema;
    }

    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> undirectedEdgeSchema) {
        this.undirectedEdgeSchema = undirectedEdgeSchema;
    }

    public void setNodeLabel(String nodeID, String nodeLabel) {
        this.nodeLabelsByNodeID.put(nodeID, nodeLabel);
    }

    public void setNodeAttributes(String nodeID, Map<String, Object> attributes) {
        Node node = this.getNode(nodeID);
        if (attributes != null) {
            node.addAttributes(attributes);
        }
    }

    public void setEdgeAttributes(String edgeID, Map<String, Object> attributes) {
        Edge edge = this.getEdge(edgeID);
        if (attributes != null) {
            edge.addAttributes(attributes);
        }
    }

    private void setupFrom(AnnotatedGraph copyFrom) {
        String id;
        this.setupNodeSchemaFrom(copyFrom);
        this.setupDirectedEdgeSchemaFrom(copyFrom);
        this.setupUndirectedEdgeSchemaFrom(copyFrom);
        for (Node node : copyFrom.getEachNode()) {
            id = node.getId();
            String label = copyFrom.getNodeLabel(id);
            Map<String, Object> attributes = Utilities.getElementAttributes((Element)node);
            this.addNode(id);
            this.setNodeLabel(id, label);
            this.setNodeAttributes(id, attributes);
        }
        for (Edge edge : copyFrom.getEachEdge()) {
            id = edge.getId();
            String node1ID = edge.getNode0().getId();
            String node2ID = edge.getNode1().getId();
            boolean isDirected = edge.isDirected();
            Map<String, Object> attributes = Utilities.getElementAttributes((Element)edge);
            this.addEdge(id, node1ID, node2ID, isDirected);
            this.setEdgeAttributes(id, attributes);
        }
    }

    private void setupNodeSchemaFrom(AnnotatedGraph copyFrom) {
        LinkedHashMap<String, String> nodeSchema = copyFrom.getNodeSchema();
        if (nodeSchema != null) {
            this.setNodeSchema(new LinkedHashMap<String, String>(nodeSchema));
        }
    }

    private void setupDirectedEdgeSchemaFrom(AnnotatedGraph copyFrom) {
        LinkedHashMap<String, String> directedEdgeSchema = copyFrom.getDirectedEdgeSchema();
        if (directedEdgeSchema != null) {
            this.setDirectedEdgeSchema(new LinkedHashMap<String, String>(directedEdgeSchema));
        }
    }

    private void setupUndirectedEdgeSchemaFrom(AnnotatedGraph copyFrom) {
        LinkedHashMap<String, String> undirectedEdgeSchema = copyFrom.getUndirectedEdgeSchema();
        if (undirectedEdgeSchema != null) {
            this.setUndirectedEdgeSchema(new LinkedHashMap<String, String>(undirectedEdgeSchema));
        }
    }
}

