/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.r;

import edu.iu.cns.r.CreateRAlgorithm;
import edu.iu.cns.r.utility.RHomeFinder;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.AllParametersMutatedOutException;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.MutateParameterUtilities;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class CreateRAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String R_HOME_DIRECTORY_ID = "rExecutableDirectory";
    private LogService logger;

    protected void activate(ComponentContext componentContext) {
        this.logger = (LogService)componentContext.locateService("LOG");
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        String rHome = CreateRAlgorithmFactory.getRHome(parameters);
        return new CreateRAlgorithm(rHome, this.logger);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        String rHomeFromPath = RHomeFinder.findRHome();
        BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
        this.processAttributeDefinitions(oldParameters, newParameters, 1, rHomeFromPath);
        this.processAttributeDefinitions(oldParameters, newParameters, 2, rHomeFromPath);
        if (newParameters.getAttributeDefinitions(-1).length == 0) {
            throw new AllParametersMutatedOutException();
        }
        return newParameters;
    }

    private void processAttributeDefinitions(ObjectClassDefinition oldParameters, BasicObjectClassDefinition newParameters, int attributeDefinitionType, String rHomeFromPathUnchecked) {
        String rHomeFromPath = rHomeFromPathUnchecked != null ? "directory:" + rHomeFromPathUnchecked : "directory:";
        AttributeDefinition[] attributeDefinitionArray = oldParameters.getAttributeDefinitions(attributeDefinitionType);
        int n = attributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition oldAttributeDefinition;
            Object newAttributeDefinition = oldAttributeDefinition = attributeDefinitionArray[n2];
            if (R_HOME_DIRECTORY_ID.equals(oldAttributeDefinition.getID())) {
                newAttributeDefinition = new BasicAttributeDefinition(oldAttributeDefinition.getID(), oldAttributeDefinition.getName(), oldAttributeDefinition.getDescription(), oldAttributeDefinition.getType(), rHomeFromPath){

                    public String validate(String value) {
                        String preValidation = super.validate(value);
                        if (preValidation != null) {
                            return preValidation;
                        }
                        if (!RHomeFinder.isValidRHome(value)) {
                            String format = "%s is not a valid R home.  (The R executable could not be found.) Please choose a different directory as your R home.";
                            String errorMessage = String.format(format, value);
                            return errorMessage;
                        }
                        return null;
                    }
                };
            }
            newParameters.addAttributeDefinition(attributeDefinitionType, newAttributeDefinition);
            ++n2;
        }
    }

    private static String getRHome(Dictionary<String, Object> parameters) {
        String rHome = (String)parameters.get(R_HOME_DIRECTORY_ID);
        if (rHome != null) {
            return rHome;
        }
        return RHomeFinder.findRHome();
    }
}

