/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.r.exportdata;

import edu.iu.cns.r.exportdata.RFileExportLog;
import edu.iu.cns.r.utility.RInstance;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class ExportCSVFromRAlgorithm
implements Algorithm {
    public static final String CSV_MIME_TYPE = "file:text/csv";
    private Data inputData;
    private String variableNameInR;
    private RInstance rInstance;
    private LogService logger;

    public ExportCSVFromRAlgorithm(Data rInstanceData, String variableNameInR, RInstance rInstance, LogService logger) {
        this.inputData = rInstanceData;
        this.variableNameInR = variableNameInR;
        this.rInstance = rInstance;
        this.logger = logger;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            RFileExportLog output = this.rInstance.exportTable(this.variableNameInR);
            output.log(this.logger, true, true);
            return this.wrapWrittenFileAsOutputData(output.getWrittenFile());
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private Data[] wrapWrittenFileAsOutputData(File writtenFile) {
        BasicData outputData = new BasicData((Object)writtenFile, CSV_MIME_TYPE);
        Dictionary metadata = outputData.getMetadata();
        String label = String.format("R variable '%s' exported to CSV", this.variableNameInR);
        metadata.put("Label", label);
        metadata.put("Parent", this.inputData);
        metadata.put("Type", "Table");
        return new Data[]{outputData};
    }
}

