/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.r.importdata;

import edu.iu.cns.r.importdata.ImportCSVIntoRAlgorithm;
import edu.iu.cns.r.utility.RInstance;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Set;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.MutateParameterUtilities;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ImportCSVIntoRAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String VARIABLE_NAME_IN_R_ID = "variableNameInR";
    public static final String VARIABLE_NAME_IN_R_DEFAULT = "importedTable";
    private LogService logger;

    protected void activate(ComponentContext componentContext) {
        this.logger = (LogService)componentContext.locateService("LOG");
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        String variableNameInR = (String)parameters.get(VARIABLE_NAME_IN_R_ID);
        RInstance rInstance = this.findRInstance(data);
        File tableToImport = this.findTableToImport(data);
        return new ImportCSVIntoRAlgorithm(variableNameInR, rInstance, tableToImport, this.logger);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        try {
            RInstance rInstance = this.findRInstance(data);
            Set<String> allRObjectNames = rInstance.getAllObjectNamesFromR();
            String defaultTableName = this.determineValidDefaultVariableName(rInstance, allRObjectNames);
            BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
            this.processAttributeDefinitions(oldParameters, newParameters, 1, defaultTableName, allRObjectNames);
            this.processAttributeDefinitions(oldParameters, newParameters, 2, defaultTableName, allRObjectNames);
            return newParameters;
        }
        catch (IOException e) {
            throw new AlgorithmCreationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private RInstance findRInstance(Data[] data) {
        if (data[0].getData() instanceof RInstance) {
            return (RInstance)data[0].getData();
        }
        return (RInstance)data[1].getData();
    }

    private File findTableToImport(Data[] data) {
        if (data[0].getData() instanceof File) {
            return (File)data[0].getData();
        }
        return (File)data[1].getData();
    }

    private String determineValidDefaultVariableName(RInstance rInstance, Set<String> allRObjectNames) throws IOException {
        String defaultVariableName = VARIABLE_NAME_IN_R_DEFAULT;
        int uniqueVariableNameCounter = 2;
        while (allRObjectNames.contains(defaultVariableName)) {
            defaultVariableName = VARIABLE_NAME_IN_R_DEFAULT + uniqueVariableNameCounter;
            ++uniqueVariableNameCounter;
        }
        return defaultVariableName;
    }

    private void processAttributeDefinitions(ObjectClassDefinition oldParameters, BasicObjectClassDefinition newParameters, int attributeDefinitionType, String defaultTableName, final Set<String> allRObjectNames) {
        AttributeDefinition[] attributeDefinitionArray = oldParameters.getAttributeDefinitions(attributeDefinitionType);
        int n = attributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition oldAttributeDefinition;
            Object newAttributeDefinition = oldAttributeDefinition = attributeDefinitionArray[n2];
            if (VARIABLE_NAME_IN_R_ID.equals(oldAttributeDefinition.getID())) {
                newAttributeDefinition = new BasicAttributeDefinition(oldAttributeDefinition.getID(), oldAttributeDefinition.getName(), oldAttributeDefinition.getDescription(), oldAttributeDefinition.getType(), defaultTableName){

                    public String validate(String value) {
                        String preValidation = super.validate(value);
                        if (preValidation != null) {
                            return preValidation;
                        }
                        if (allRObjectNames.contains(value)) {
                            String format = "%s is already declared in this R instance.  Please choose a different variable name.";
                            String errorMessage = String.format(format, value);
                            return errorMessage;
                        }
                        return null;
                    }
                };
            }
            newParameters.addAttributeDefinition(attributeDefinitionType, newAttributeDefinition);
            ++n2;
        }
    }
}

