/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.r.utility;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.cishell.utilities.StringUtilities;
import org.cishell.utilities.ToCaseFunction;

public class RHomeFinder {
    public static final Collection<String> R_HOME_ENVIRONMENT_VARIABLES_TO_CHECK = Collections2.transform((Collection)Sets.newHashSet((Object[])new String[]{"R", "R_HOME"}), (Function)ToCaseFunction.LOWER);

    public static String findRHome() {
        Map<String, String> environmentVariables = System.getenv();
        for (String key : environmentVariables.keySet()) {
            String lowerCasedKey = key.toLowerCase();
            if (!R_HOME_ENVIRONMENT_VARIABLES_TO_CHECK.contains(lowerCasedKey)) continue;
            String rHome = StringUtilities.stripSurroundingQuotes((String)environmentVariables.get(key));
            String rHomeWithBin = String.format("%s%sbin", rHome, File.separator);
            if (RHomeFinder.isValidRHome(rHome)) {
                return rHome;
            }
            if (!RHomeFinder.isValidRHome(rHomeWithBin)) continue;
            return rHomeWithBin;
        }
        return null;
    }

    public static boolean isValidRHome(String path) {
        String[] rDirectoryFileNames;
        File rDirectory = new File(path);
        if (!rDirectory.exists() || !rDirectory.isDirectory()) {
            return false;
        }
        String[] stringArray = rDirectoryFileNames = rDirectory.list();
        int n = rDirectoryFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String rBaseFileName;
            String rDirectoryFileName = stringArray[n2];
            File rDirectoryFile = new File(rDirectoryFileName);
            if (!rDirectoryFile.isDirectory() && "R".equalsIgnoreCase(rBaseFileName = FilenameUtils.getBaseName((String)rDirectoryFile.getName()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

