/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.r.utility;

import bsh.EvalError;
import bsh.Interpreter;
import com.google.common.collect.Sets;
import edu.iu.cns.r.exportdata.RFileExportLog;
import edu.iu.cns.r.utility.JavaCodeStreamReader;
import edu.iu.cns.r.utility.ROutputStreamReader;
import edu.iu.cns.r.utility.RStreamLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.cishell.utilities.FileCopyingException;
import org.cishell.utilities.FileUtilities;
import org.cishell.utilities.StringUtilities;
import org.osgi.service.log.LogService;

public class RInstance {
    public static final String CSV_FILE_EXTENSION = ".csv";
    public static final String TEMPORARY_WORKING_DIRECTORY_PREFIX = "r_instance";
    public static final String TEMPORARY_IMPORT_TABLE_PREFIX = "_import_";
    public static final String TEMPORARY_EXPORT_TABLE_PREFIX = "_export_";
    private String rHome;
    private Interpreter javaInterpreter = new Interpreter();
    private File temporaryWorkingDirectory = FileUtilities.createTempDirectory((String)"r_instance");

    public RInstance(String rHome, LogService logger) {
        this.rHome = rHome;
        try {
            RStreamLog messagesFromPreparingR = RInstance.reportOutputFromProcess(this.installMakeJavaRModule(), false);
            messagesFromPreparingR.log(logger, false, true);
        }
        catch (Exception e) {
            logger.log(1, StringUtilities.getStackTraceAsString((Throwable)e));
        }
    }

    public Process installMakeJavaRModule() throws IOException {
        String rPath = String.format("%s%s%s", this.rHome, File.separator, "R");
        File temporaryMakeJava_RFile = File.createTempFile("makejava", ".r", this.temporaryWorkingDirectory);
        FileUtilities.writeStreamToFile((InputStream)RInstance.class.getResourceAsStream("/edu/iu/cns/r/makejava.r"), (File)temporaryMakeJava_RFile);
        List<String> command = Arrays.asList(rPath, "--save", "-f", temporaryMakeJava_RFile.getAbsolutePath());
        ProcessBuilder rScriptProcessBuilder = new ProcessBuilder(command);
        rScriptProcessBuilder.directory(this.temporaryWorkingDirectory);
        return rScriptProcessBuilder.start();
    }

    public RStreamLog runRGUI() throws IOException {
        String rGUIPath = String.format("%s%s%s", this.rHome, File.separator, "Rgui");
        String rDataPath = String.format("%s%s%s", this.temporaryWorkingDirectory.getAbsolutePath(), File.separator, ".RData");
        List<String> command = Arrays.asList(rGUIPath, rDataPath, "--save");
        ProcessBuilder rGUIProcessBuilder = new ProcessBuilder(command);
        rGUIProcessBuilder.directory(this.temporaryWorkingDirectory);
        return RInstance.reportOutputFromProcess(rGUIProcessBuilder.start(), false);
    }

    public Object getObjectFromR(String rExpression, String javaVariableName) throws IOException {
        String rPath = String.format("%s%s%s", this.rHome, File.separator, "R");
        String rDataPath = String.format("%s%s%s", this.temporaryWorkingDirectory.getAbsolutePath(), File.separator, ".RData");
        String fullRExpression = String.format("cat(createJavaCodeForObject(%s, '%s'));q()", rExpression, javaVariableName);
        List<String> command = Arrays.asList(rPath, "--slave", rDataPath, "-e", fullRExpression);
        ProcessBuilder rProcessBuilder = new ProcessBuilder(command);
        rProcessBuilder.directory(this.temporaryWorkingDirectory);
        Process rProcess = rProcessBuilder.start();
        JavaCodeStreamReader javaCodeReader = new JavaCodeStreamReader(rProcess.getInputStream(), this.javaInterpreter);
        javaCodeReader.start();
        try {
            javaCodeReader.join();
            rProcess.waitFor();
            return this.javaInterpreter.eval(javaVariableName);
        }
        catch (EvalError e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Double getDoubleFromR(String rExpression, String javaVariableName) throws IOException {
        return (Double)this.getObjectFromR(rExpression, javaVariableName);
    }

    public List<Double> getDoubleListFromR(String rExpression, String javaVariableName) throws IOException {
        return Arrays.asList((Double[])this.getObjectFromR(rExpression, javaVariableName));
    }

    public String getStringFromR(String rExpression, String javaVariableName) throws IOException {
        return (String)this.getObjectFromR(rExpression, javaVariableName);
    }

    public List<String> getStringListFromR(String rExpression, String javaVariableName) throws IOException {
        return Arrays.asList((String[])this.getObjectFromR(rExpression, javaVariableName));
    }

    public Set<String> getAllObjectNamesFromR() throws IOException {
        return Sets.newHashSet(this.getStringListFromR("objects()", "objects").iterator());
    }

    public RStreamLog importTable(File tableFile, boolean hasHeader, String rVariableName) throws FileCopyingException, IOException {
        File localTableFile = File.createTempFile(String.valueOf(tableFile.getName()) + TEMPORARY_IMPORT_TABLE_PREFIX, CSV_FILE_EXTENSION, this.temporaryWorkingDirectory);
        FileUtilities.copyFile((File)tableFile, (File)localTableFile);
        String hasHeaderString = new Boolean(hasHeader).toString().toUpperCase();
        String rCode = String.format("%s <- read.table('%s', header=%s, fill=TRUE, strip.white=TRUE, sep=',')", rVariableName, localTableFile.getName(), hasHeaderString);
        return this.executeArbitaryRCode(rCode);
    }

    public RFileExportLog exportTable(String rVariableName) throws IOException {
        File tempFile = File.createTempFile(String.valueOf(rVariableName) + TEMPORARY_EXPORT_TABLE_PREFIX, CSV_FILE_EXTENSION, this.temporaryWorkingDirectory);
        String temporaryTableFileName = tempFile.getName();
        String rCode = String.format("write.csv(%s, file='%s', sep=',', quote=TRUE, row.names=FALSE)", rVariableName, temporaryTableFileName);
        RStreamLog output = this.executeArbitaryRCode(rCode);
        return new RFileExportLog(output, tempFile);
    }

    public RStreamLog executeArbitaryRCode(String rCode) throws IOException {
        String rPath = String.format("%s%s%s", this.rHome, File.separator, "R");
        String rDataPath = String.format("%s%s%s", this.temporaryWorkingDirectory.getAbsolutePath(), File.separator, ".RData");
        List<String> command = Arrays.asList(rPath, rDataPath, "--save", "-e", rCode);
        ProcessBuilder rProcessBuilder = new ProcessBuilder(command);
        rProcessBuilder.directory(this.temporaryWorkingDirectory);
        return RInstance.reportOutputFromProcess(rProcessBuilder.start(), false);
    }

    public static RStreamLog reportOutputFromProcess(Process process, boolean shouldPrintImmediately) {
        try {
            ROutputStreamReader standardOut = new ROutputStreamReader(process.getInputStream(), false, shouldPrintImmediately);
            ROutputStreamReader standardError = new ROutputStreamReader(process.getErrorStream(), true, shouldPrintImmediately);
            standardOut.start();
            standardError.start();
            process.waitFor();
            return new RStreamLog(standardOut.getOutput(), standardError.getOutput());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RStreamLog("", "");
        }
    }
}

