/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.visualization.gui.awt;

import edu.iu.cns.visualization.Visualization;
import edu.iu.cns.visualization.generator.VisualizationGenerator;
import edu.iu.cns.visualization.gui.awt.AWTVisualizationControlPanel;
import edu.iu.cns.visualization.gui.awt.AWTVisualizationDisplayPanel;
import edu.iu.cns.visualization.gui.awt.AWTVisualizationGUIBuilder;
import edu.iu.cns.visualization.gui.awt.AWTVisualizationParametersContainer;
import edu.iu.cns.visualization.utility.VisualizationMessages;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.freehep.util.export.ExportDialog;

public class AWTVisualizationRunner {
    public static final String PAUSE_RESUME_BUTTON_COMMAND = "pause/resume";
    public static final String ENABLE_DISABLE_SCALING_CHECK_BOX_COMMAND = "enable/disable scaling";
    private VisualizationGenerator<?> visualizationGenerator;
    private Visualization visualization;
    private AWTVisualizationGUIBuilder guiBuilder;
    private VisualizationMessages messages;
    private AWTVisualizationDisplayPanel visualizationDisplayPanel;
    private AWTVisualizationControlPanel visualizationControlPanel;
    private JSplitPane visualizationContainerPanel;
    private AWTVisualizationParametersContainer parametersContainer;
    private JSplitPane containerPanel;
    private JFrame frame;

    public AWTVisualizationRunner(VisualizationGenerator<?> visualizationGenerator, AWTVisualizationGUIBuilder guiBuilder, Dimension initialSize) {
        this.visualizationGenerator = visualizationGenerator;
        this.visualization = this.visualizationGenerator.generateVisualization();
        this.guiBuilder = guiBuilder;
        this.visualizationDisplayPanel = new AWTVisualizationDisplayPanel(initialSize, this.messages);
        this.visualizationControlPanel = new AWTVisualizationControlPanel();
        this.visualizationContainerPanel = new JSplitPane(0, this.visualizationDisplayPanel, this.visualizationControlPanel);
        this.parametersContainer = new AWTVisualizationParametersContainer(this, guiBuilder, visualizationGenerator);
        JFrame frame = new JFrame(this.visualization.title());
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(this.parametersContainer);
        frame.pack();
        frame.setVisible(true);
        this.containerPanel = new JSplitPane(1, this.parametersContainer, this.visualizationContainerPanel);
        this.frame = AWTVisualizationRunner.createFrame(this.visualization, this.visualizationDisplayPanel, this.containerPanel);
    }

    private static JFrame createFrame(Visualization visualization, final AWTVisualizationDisplayPanel visualizationPanel, Container contents) {
        final JFrame frame = new JFrame(visualization.title());
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(contents);
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu file = new JMenu("File");
        menuBar.add(file);
        JMenuItem exportItem = new JMenuItem("Export...");
        exportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog export = new ExportDialog();
                export.showExportDialog((Component)visualizationPanel, "Export view as ...", (Component)visualizationPanel, "export");
            }
        });
        file.add(exportItem);
        JMenuItem quitItem = new JMenuItem("Quit");
        quitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        file.add(quitItem);
        return frame;
    }

    public void run() {
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void tearDown() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    private Component createContentPane() {
        return this.visualizationContainerPanel;
    }

    private Component createControlsPane() {
        JPanel panel = new JPanel();
        return panel;
    }
}

