/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.visualization.utility.wordwrap;

import com.google.common.base.Objects;
import com.google.common.collect.AbstractIterator;
import java.text.BreakIterator;
import java.util.Iterator;
import java.util.Locale;

public final class LineChunks
implements Iterable<String> {
    private final String text;
    private final Locale locale;

    private LineChunks(String text, Locale locale) {
        this.text = text;
        this.locale = locale;
    }

    public static LineChunks in(String text) {
        return new LineChunks(text, Locale.getDefault());
    }

    public LineChunks withLocale(Locale locale) {
        return new LineChunks(this.text, locale);
    }

    @Override
    public Iterator<String> iterator() {
        return new WordIterator(this.text, this.locale);
    }

    public String getText() {
        return this.text;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("text", (Object)this.text).add("locale", (Object)this.locale).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.text, this.locale});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LineChunks)) {
            return false;
        }
        LineChunks that = (LineChunks)o;
        return Objects.equal((Object)this.text, (Object)that.text) && Objects.equal((Object)this.locale, (Object)that.locale);
    }

    private static final class WordIterator
    extends AbstractIterator<String> {
        private final String text;
        private final BreakIterator breakIterator;
        private int start;
        private int end;

        private WordIterator(String text, Locale locale) {
            this.text = text;
            this.breakIterator = BreakIterator.getLineInstance(locale);
            this.breakIterator.setText(text);
            this.start = this.breakIterator.first();
        }

        protected String computeNext() {
            this.end = this.breakIterator.next();
            if (this.end != -1) {
                String word = this.text.substring(this.start, this.end);
                this.start = this.end;
                return word;
            }
            return (String)this.endOfData();
        }
    }
}

