/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.visualization.utility.wordwrap;

import com.google.common.base.Objects;
import edu.iu.cns.visualization.utility.wordwrap.LineMetric;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public final class LineMetrics {
    private LineMetrics() {
    }

    public static LineMetric length() {
        return new LengthLineMetric();
    }

    public static LineMetric widthInContext(Font font, Graphics graphics) {
        return new WidthLineMetric(font, graphics);
    }

    public static LineMetric widthInFont(Font font) {
        return LineMetrics.widthInContext(font, FictionalGraphicsContext.getInstance());
    }

    protected static class FictionalGraphicsContext {
        private static Graphics _instance = null;

        private FictionalGraphicsContext() {
        }

        public static synchronized Graphics getInstance() {
            if (_instance == null) {
                _instance = new BufferedImage(5, 5, 1).createGraphics();
            }
            return _instance;
        }
    }

    private static final class LengthLineMetric
    implements LineMetric {
        private LengthLineMetric() {
        }

        @Override
        public int sizeOf(String line) {
            return line.length();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).toString();
        }
    }

    private static final class WidthLineMetric
    implements LineMetric {
        private final FontMetrics fontMetrics;

        private WidthLineMetric(Font font, Graphics context) {
            this.fontMetrics = context.getFontMetrics(font);
        }

        @Override
        public int sizeOf(String line) {
            return this.fontMetrics.stringWidth(line);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("fontMetrics", (Object)this.fontMetrics).toString();
        }
    }
}

