/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.cns.visualization.utility.wordwrap;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import edu.iu.cns.visualization.utility.wordwrap.LineChunks;
import edu.iu.cns.visualization.utility.wordwrap.LineMetric;
import java.util.Iterator;

public final class WordWrapper {
    private final Strategy strategy;

    private WordWrapper(Strategy strategy) {
        this.strategy = strategy;
    }

    public static WordWrapper fewestLines(LineMetric lineMetric, int targetedSize) {
        return new WordWrapper(new GreedyStrategy(new MetricAtMost(lineMetric, targetedSize)));
    }

    public Iterable<String> wrap(String text) {
        return this.wrap(LineChunks.in(text));
    }

    public Iterable<String> wrap(Iterable<String> words) {
        return this.wrap(words.iterator());
    }

    public Iterable<String> wrap(final Iterator<String> words) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return WordWrapper.this.strategy.lineIteratorOver(words);
            }
        };
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("strategy", (Object)this.strategy).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.strategy});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof WordWrapper)) {
            return false;
        }
        WordWrapper that = (WordWrapper)o;
        return Objects.equal((Object)this.strategy, (Object)that.strategy);
    }

    private static final class GreedyStrategy
    implements Strategy {
        private final Predicate<String> shouldFitOnOneLine;

        public GreedyStrategy(Predicate<String> shouldFitOnOneLine) {
            this.shouldFitOnOneLine = shouldFitOnOneLine;
        }

        @Override
        public Iterator<String> lineIteratorOver(Iterator<String> words) {
            return new LineIterator(words);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("shouldFitOnOneLine", this.shouldFitOnOneLine).toString();
        }

        private final class LineIterator
        extends AbstractIterator<String> {
            private final PeekingIterator<String> words;

            public LineIterator(Iterator<String> words) {
                this.words = Iterators.peekingIterator(words);
            }

            protected String computeNext() {
                LineBuilder line = new LineBuilder();
                while (this.words.hasNext()) {
                    boolean accepted = line.offer((String)this.words.peek());
                    if (!accepted) break;
                    this.words.next();
                }
                if (line.isEmpty()) {
                    assert (!this.words.hasNext());
                    return (String)this.endOfData();
                }
                return line.toString();
            }

            final class LineBuilder {
                private final StringBuilder text;

                LineBuilder() {
                    this("");
                }

                LineBuilder(String text) {
                    this.text = new StringBuilder(text);
                }

                boolean offer(String word) {
                    if (this.canFit(word) || this.isEmpty()) {
                        this.append(word);
                        return true;
                    }
                    return false;
                }

                boolean isEmpty() {
                    return this.text.toString().isEmpty();
                }

                private boolean canFit(String moreText) {
                    return GreedyStrategy.this.shouldFitOnOneLine.apply((Object)(String.valueOf(this.text.toString()) + moreText));
                }

                private void append(String moreText) {
                    this.text.append(moreText);
                }

                public String toString() {
                    return this.text.toString();
                }
            }
        }
    }

    private static final class MetricAtMost
    implements Predicate<String> {
        private final LineMetric lineMetric;
        private final int targetedSize;

        private MetricAtMost(LineMetric lineMetric, int targetedSize) {
            this.lineMetric = lineMetric;
            this.targetedSize = targetedSize;
        }

        public boolean apply(String line) {
            return this.lineMetric.sizeOf(line) <= this.targetedSize;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("lineMetric", (Object)this.lineMetric).add("targetedSize", this.targetedSize).toString();
        }
    }

    private static interface Strategy {
        public Iterator<String> lineIteratorOver(Iterator<String> var1);
    }
}

