/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.blondelcommunitydetection;

import edu.iu.nwb.analysis.blondelcommunitydetection.NetworkInfo;
import edu.iu.nwb.analysis.blondelcommunitydetection.OuterNodeAttributeRemover;
import edu.iu.nwb.analysis.blondelcommunitydetection.OuterNodeAttributeRemoverException;
import edu.iu.nwb.analysis.blondelcommunitydetection.Utilities;
import edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages.CommunityDetectionRunner;
import edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages.NWBAndTreeFilesMerger;
import edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages.NWBToBINConverter;
import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class BlondelCommunityDetectionAlgorithm
implements Algorithm {
    public static final String WEIGHT_FIELD_ID = "weight";
    public static final String IS_WEIGHTED_FIELD_ID = "isweighted";
    public static final String NO_EDGE_WEIGHT_VALUE = "unweighted";
    private AlgorithmFactory blondelCommunityDetectionAlgorithmFactory;
    private Data inputData;
    private File inputNWBFile;
    private String weightAttribute;
    private boolean isWeighted;
    private Dictionary<String, Object> parameters;
    private CIShellContext context;
    private LogService logger;

    public BlondelCommunityDetectionAlgorithm(AlgorithmFactory blondelCommunityDetectionAlgorithmFactory, Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        this.blondelCommunityDetectionAlgorithmFactory = blondelCommunityDetectionAlgorithmFactory;
        this.inputData = data[0];
        this.inputNWBFile = (File)this.inputData.getData();
        this.weightAttribute = parameters.get(WEIGHT_FIELD_ID).toString();
        this.isWeighted = !this.weightAttribute.equals(NO_EDGE_WEIGHT_VALUE);
        this.parameters = parameters;
        this.context = context;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File outputNWBFile;
        NetworkInfo networkInfo = new NetworkInfo();
        File binFile = NWBToBINConverter.convertNWBFileToBINFile(this.inputNWBFile, networkInfo, this.weightAttribute, this.isWeighted);
        CommunityDetectionRunner communityDetectionRunner = new CommunityDetectionRunner(this.blondelCommunityDetectionAlgorithmFactory, this.parameters, this.context);
        File communityTreeFile = communityDetectionRunner.runCommunityDetection(binFile, this.inputData);
        File tempNWBFile = NWBAndTreeFilesMerger.mergeCommunitiesFileWithNWBFile(communityTreeFile, this.inputNWBFile, networkInfo);
        try {
            outputNWBFile = OuterNodeAttributeRemover.removeOutermostNodeAttributeIfDuplicate(tempNWBFile);
        }
        catch (OuterNodeAttributeRemoverException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
        Data[] outData = Utilities.wrapFileAsOutputData(outputNWBFile, "file:text/nwb", this.inputData);
        return outData;
    }
}

