/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.blondelcommunitydetection;

import edu.iu.nwb.analysis.blondelcommunitydetection.BlondelCommunityDetectionAlgorithm;
import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.AlgorithmUtilities;
import org.cishell.utilities.MutateParameterUtilities;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class BlondelCommunityDetectionAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    private BundleContext bundleContext;

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        AlgorithmFactory blondelExecutableAlgorithmFactory = AlgorithmUtilities.getAlgorithmFactoryByPID((String)"edu.iu.nwb.shared.blondelexecutable", (BundleContext)this.bundleContext);
        return new BlondelCommunityDetectionAlgorithm(blondelExecutableAlgorithmFactory, data, parameters, context);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        Data inData = data[0];
        File inputNWBFile = (File)inData.getData();
        GetNWBFileMetadata nwbFileMetaDataGetter = new GetNWBFileMetadata();
        try {
            NWBFileParser nwbParser = new NWBFileParser(inputNWBFile);
            nwbParser.parse((NWBFileParserHandler)nwbFileMetaDataGetter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
        LinkedHashMap<String, String> edgeSchema = this.getEdgeSchema(nwbFileMetaDataGetter);
        BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
        AttributeDefinition[] oldAttributeDefinitions = oldParameters.getAttributeDefinitions(-1);
        List<String> numberKeysTypes = Arrays.asList("int", "float");
        List<String> numberKeysToSkip = Arrays.asList("source", "target");
        List<String> numberKeysToAdd = Arrays.asList("unweighted");
        AttributeDefinition[] attributeDefinitionArray = oldAttributeDefinitions;
        int n = oldAttributeDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition oldAttributeDefinition = attributeDefinitionArray[n2];
            String oldAttributeDefinitionID = oldAttributeDefinition.getID();
            AttributeDefinition newAttributeDefinition = oldAttributeDefinition;
            if (oldAttributeDefinitionID.equals("weight")) {
                newAttributeDefinition = MutateParameterUtilities.formAttributeDefinitionFromMap((AttributeDefinition)oldAttributeDefinition, edgeSchema, numberKeysTypes, numberKeysToSkip, numberKeysToAdd);
            }
            newParameters.addAttributeDefinition(1, newAttributeDefinition);
            ++n2;
        }
        return newParameters;
    }

    private LinkedHashMap<String, String> getEdgeSchema(GetNWBFileMetadata nwbFileMetaDataGetter) {
        LinkedHashMap directedEdgeSchema = nwbFileMetaDataGetter.getDirectedEdgeSchema();
        if (directedEdgeSchema != null) {
            return directedEdgeSchema;
        }
        return nwbFileMetaDataGetter.getUndirectedEdgeSchema();
    }
}

