/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.blondelcommunitydetection;

import edu.iu.nwb.analysis.blondelcommunitydetection.NetworkInfo;
import java.util.ArrayList;

public class Node {
    private int originalID;
    private int newID;
    private int edgeCountForOutput = 0;
    private int actualEdgeCount = 0;
    private long startingEdgeOffsetInFile = 0L;
    private long workingEdgeOffsetInFile = 0L;
    private long startingWeightOffsetInFile = 0L;
    private long workingWeightOffsetInFile = 0L;
    private ArrayList<Integer> communities = new ArrayList();

    private Node(int originalID, int newID) {
        this.originalID = originalID;
        this.newID = newID;
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public int getNewID() {
        return this.newID;
    }

    public int getEdgeCountForOutput() {
        return this.edgeCountForOutput;
    }

    public int getActualEdgeCount() {
        return this.actualEdgeCount;
    }

    public long getStartingEdgeOffsetInFile() {
        return this.startingEdgeOffsetInFile;
    }

    public long getWorkingEdgeOffsetInFile() {
        return this.workingEdgeOffsetInFile;
    }

    public long getStartingWeightOffsetInFile() {
        return this.startingWeightOffsetInFile;
    }

    public long getWorkingWeightOffsetInFile() {
        return this.workingWeightOffsetInFile;
    }

    public ArrayList<Integer> getCommunities() {
        return this.communities;
    }

    public NetworkInfo incrementEdgeCount(NetworkInfo networkInfo) {
        ++this.actualEdgeCount;
        networkInfo.incrementTotalEdgeCount();
        return networkInfo;
    }

    public void setEdgeCountForOutput(int edgeCountForOutput) {
        this.edgeCountForOutput = edgeCountForOutput;
    }

    public void setStartingEdgeOffsetInFile(long offsetInFile) {
        this.workingEdgeOffsetInFile = this.startingEdgeOffsetInFile = offsetInFile;
    }

    public void incrementWorkingEdgeOffsetInFile() {
        this.workingEdgeOffsetInFile += 4L;
    }

    public void setStartingWeightOffsetInFile(long offsetInFile) {
        this.workingWeightOffsetInFile = this.startingWeightOffsetInFile = offsetInFile;
    }

    public void incrementWorkingWeightOffsetInFile() {
        this.workingWeightOffsetInFile += 4L;
    }

    public NetworkInfo addCommunity(Integer communityID, NetworkInfo networkInfo) {
        this.communities.add(communityID);
        int communityCount = this.communities.size();
        if (communityCount > networkInfo.getMaxCommunityLevel()) {
            networkInfo.setMaxCommunityLevel(communityCount);
        }
        return networkInfo;
    }

    public static Node getOrCreateNode(int originalID, NetworkInfo networkInfo) {
        Node nodeThatAlreadyExists = networkInfo.findNodeByOriginalID(originalID);
        if (nodeThatAlreadyExists != null) {
            return nodeThatAlreadyExists;
        }
        Node newNode = new Node(originalID, networkInfo.getRenumberingID());
        networkInfo.addNode(newNode);
        networkInfo.incrementRenumberingID();
        return newNode;
    }
}

