/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.blondelcommunitydetection;

import com.google.common.base.Joiner;
import edu.iu.nwb.analysis.blondelcommunitydetection.OuterNodeAttributeRemoverException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.cishell.utilities.FileUtilities;

public final class OuterNodeAttributeRemover {
    private static final String TAB = "\t";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String SECTION_HEADER = "*";
    private static final String ISOLATE_CLUSTER = "\"isolate";
    private static final Joiner joiner = Joiner.on((String)"\t");

    private OuterNodeAttributeRemover() {
    }

    public static File removeOutermostNodeAttributeIfDuplicate(File inputFile) throws OuterNodeAttributeRemoverException {
        File result = inputFile;
        File tmp = null;
        while (tmp != result) {
            tmp = result;
            result = OuterNodeAttributeRemover.removeDuplicateAttributes(result);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File removeDuplicateAttributes(File inputFile) throws OuterNodeAttributeRemoverException {
        File file;
        BufferedWriter writer;
        BufferedReader reader;
        block6: {
            reader = null;
            writer = null;
            reader = new BufferedReader(new FileReader(inputFile));
            File outputFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"blondel-nwb-", (String)"nwb");
            writer = new BufferedWriter(new FileWriter(outputFile));
            if (!OuterNodeAttributeRemover.parseNodeEntries(reader, writer)) break block6;
            OuterNodeAttributeRemover.parseEdgeEntries(reader, writer);
            File file2 = outputFile;
            OuterNodeAttributeRemover.close(reader);
            OuterNodeAttributeRemover.close(writer);
            return file2;
        }
        try {
            file = inputFile;
        }
        catch (FileNotFoundException e) {
            try {
                throw new OuterNodeAttributeRemoverException("Failed to initial " + inputFile, e);
                catch (IOException e2) {
                    throw new OuterNodeAttributeRemoverException("Failed pass nodes and edges attributes", e2);
                }
            }
            catch (Throwable throwable) {
                OuterNodeAttributeRemover.close(reader);
                OuterNodeAttributeRemover.close(writer);
                throw throwable;
            }
        }
        OuterNodeAttributeRemover.close(reader);
        OuterNodeAttributeRemover.close(writer);
        return file;
    }

    private static boolean parseNodeEntries(BufferedReader bufferedReader, Writer writer) throws IOException {
        OuterNodeAttributeRemover.writeLine(writer, bufferedReader.readLine());
        String line = bufferedReader.readLine();
        String[] lineArray = line.split(TAB);
        OuterNodeAttributeRemover.writeLine(writer, joiner.join((Object[])Arrays.copyOfRange(lineArray, 0, lineArray.length - 1)));
        while ((line = bufferedReader.readLine()) != null) {
            lineArray = line.split(TAB);
            int size = lineArray.length;
            if (size == 0) continue;
            if (OuterNodeAttributeRemover.isSectionHeader(lineArray[0])) {
                OuterNodeAttributeRemover.writeLine(writer, line);
                break;
            }
            if (OuterNodeAttributeRemover.outestAttributeIsNotDuplicate(lineArray)) {
                return false;
            }
            String newString = joiner.join((Object[])Arrays.copyOfRange(lineArray, 0, lineArray.length - 1));
            OuterNodeAttributeRemover.writeLine(writer, newString);
        }
        return true;
    }

    private static void writeLine(Writer writer, String line) throws IOException {
        writer.write(line);
        writer.write(NEW_LINE);
    }

    private static void parseEdgeEntries(BufferedReader bufferedReader, Writer writer) throws IOException {
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            OuterNodeAttributeRemover.writeLine(writer, line);
        }
    }

    private static boolean isSectionHeader(String string) {
        return string.startsWith(SECTION_HEADER);
    }

    private static boolean outestAttributeIsNotDuplicate(String[] strings) {
        int size = strings.length;
        if (size < 2 || strings[size - 1].startsWith(ISOLATE_CLUSTER)) {
            return false;
        }
        return !strings[size - 1].equals(strings[size - 2]);
    }

    private static void close(Closeable c) throws OuterNodeAttributeRemoverException {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            throw new OuterNodeAttributeRemoverException("Error when attempting to close an NWB file stream using close() method.", e);
        }
    }
}

