/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages;

import edu.iu.nwb.analysis.blondelcommunitydetection.Utilities;
import edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages.exceptiontypes.CommunityDetectionRunnerException;
import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.Data;

public class CommunityDetectionRunner {
    private AlgorithmFactory communityDetectionFactory;
    private Dictionary<String, Object> parameters;
    private CIShellContext ciShellContext;

    public CommunityDetectionRunner(AlgorithmFactory communityDetectionFactory, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        this.communityDetectionFactory = communityDetectionFactory;
        this.parameters = parameters;
        this.ciShellContext = ciShellContext;
    }

    public File runCommunityDetection(File inputBINFile, Data inputData) throws CommunityDetectionRunnerException {
        Data[] communityDetectionData = Utilities.wrapFileAsOutputData(inputBINFile, "file:text/bin", inputData);
        Algorithm communityDetectionAlgorithm = this.communityDetectionFactory.createAlgorithm(communityDetectionData, this.parameters, this.ciShellContext);
        try {
            Data[] executionResultData = communityDetectionAlgorithm.execute();
            File treeFile = (File)executionResultData[0].getData();
            return treeFile;
        }
        catch (AlgorithmExecutionException e) {
            throw new CommunityDetectionRunnerException(e);
        }
    }
}

