/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages;

import edu.iu.nwb.analysis.blondelcommunitydetection.NetworkInfo;
import edu.iu.nwb.analysis.blondelcommunitydetection.TreeFileParsingException;
import edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages.exceptiontypes.NWBAndTreeFileMergingException;
import edu.iu.nwb.analysis.blondelcommunitydetection.nwbfileparserhandlers.tree_to_nwb.Merger;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.cishell.utilities.FileUtilities;

public class NWBAndTreeFilesMerger {
    public static File mergeCommunitiesFileWithNWBFile(File communitiesFile, File nwbFile, NetworkInfo networkInfo) throws NWBAndTreeFileMergingException {
        try {
            File outputNWBFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"blondel-nwb-", (String)"nwb");
            Merger merger = new Merger(communitiesFile, outputNWBFile, networkInfo);
            NWBFileParser fileParser = new NWBFileParser(nwbFile);
            fileParser.parse((NWBFileParserHandler)merger);
            return outputNWBFile;
        }
        catch (FileNotFoundException e) {
            throw new NWBAndTreeFileMergingException(e);
        }
        catch (IOException e) {
            throw new NWBAndTreeFileMergingException(e);
        }
        catch (ParsingException e) {
            throw new NWBAndTreeFileMergingException(e);
        }
        catch (TreeFileParsingException e) {
            throw new NWBAndTreeFileMergingException(e);
        }
    }
}

