/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages;

import edu.iu.nwb.analysis.blondelcommunitydetection.NetworkInfo;
import edu.iu.nwb.analysis.blondelcommunitydetection.algorithmstages.exceptiontypes.NWBToBINConversionException;
import edu.iu.nwb.analysis.blondelcommunitydetection.nwbfileparserhandlers.nwb_to_bin.Converter;
import edu.iu.nwb.analysis.blondelcommunitydetection.nwbfileparserhandlers.nwb_to_bin.Preprocessor;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import org.cishell.utilities.FileUtilities;

public class NWBToBINConverter {
    public static File convertNWBFileToBINFile(File inputNWBFile, NetworkInfo networkInfo, String weightAttribute, boolean isWeighted) throws NWBToBINConversionException {
        NWBToBINConverter.preprocessNWBFile(inputNWBFile, networkInfo, weightAttribute, isWeighted);
        return NWBToBINConverter.doConversion(inputNWBFile, networkInfo, weightAttribute, isWeighted);
    }

    private static void preprocessNWBFile(File nwbFile, NetworkInfo networkInfo, String weightAttribute, boolean isWeighted) throws NWBToBINConversionException {
        Preprocessor preprocessor = new Preprocessor(networkInfo, weightAttribute, isWeighted);
        try {
            NWBFileParser preprocessorFileParser = new NWBFileParser(nwbFile);
            preprocessorFileParser.parse((NWBFileParserHandler)preprocessor);
            NWBToBINConversionException exceptionThrown = preprocessor.getExceptionThrown();
            if (exceptionThrown != null) {
                throw exceptionThrown;
            }
        }
        catch (IOException e) {
            String exceptionMessage = "Failed to read NWB file that is being preprocessed for conversion to BIN file: \"" + e.getMessage() + "\"";
            throw new NWBToBINConversionException(exceptionMessage, e);
        }
        catch (ParsingException e) {
            String exceptionMessage = "Failed to parse NWB file that is being preprocessed for conversion to BIN file: \"" + e.getMessage() + "\"";
            throw new NWBToBINConversionException(exceptionMessage, e);
        }
        catch (NWBToBINConversionException e) {
            String exceptionMessage = "Failed to parse NWB file that is being preprocessed for conversion to BIN file: \"" + e.getMessage() + "\"";
            throw new NWBToBINConversionException(exceptionMessage, e);
        }
    }

    private static File doConversion(File nwbFile, NetworkInfo networkInfo, String weightAttribute, boolean isWeighted) throws NWBToBINConversionException {
        File outputBINFile;
        try {
            outputBINFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"TEMP-BLONDEL", (String)"bin");
        }
        catch (IOException e) {
            throw new NWBToBINConversionException("Failed to create temporary BIN file.", e);
        }
        Converter converter = new Converter(networkInfo, outputBINFile, weightAttribute, isWeighted);
        try {
            NWBFileParser converterFileParser = new NWBFileParser(nwbFile);
            converterFileParser.parse((NWBFileParserHandler)converter);
        }
        catch (IOException e) {
            throw new NWBToBINConversionException("Failed to read NWB file that is being converted to BIN file.", e);
        }
        catch (ParsingException e) {
            throw new NWBToBINConversionException("Failed to parse NWB file that is being converted to BIN file.", e);
        }
        return outputBINFile;
    }
}

