/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.blondelcommunitydetection.nwbfileparserhandlers.nwb_to_bin;

import edu.iu.nwb.analysis.blondelcommunitydetection.NetworkInfo;
import edu.iu.nwb.analysis.blondelcommunitydetection.Node;
import edu.iu.nwb.util.nwbfile.NWBFileParserAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;

public class Converter
extends NWBFileParserAdapter {
    private static final String WINDOWS_95_PLATFORM = "Windows 95";
    private static final String WINDOWS_98_PLATFORM = "Windows 98";
    private static final String WINDOWS_NT_PLATFORM = "Windows NT";
    private static final String WINDOWS_VISTA_PLATFORM = "Windows Vista";
    private static final String WINDOWS_XP_PLATFORM = "Windows XP";
    private static final String WINDOWS_7_PLATFORM = "Windows 7";
    private static final String[] WINDOWS_PLATFORMS = new String[]{"Windows 95", "Windows 98", "Windows NT", "Windows Vista", "Windows XP", "Windows 7"};
    public static final int WEIGHT_RESOLUTION = 10000000;
    private boolean shouldHaltParsing = false;
    private NetworkInfo networkInfo;
    private RandomAccessFile outputBINFile;
    private String weightAttribute;
    private boolean isWeighted;

    public Converter(NetworkInfo networkInfo, File outputFile, String weightAttribute, boolean isWeighted) {
        this.networkInfo = networkInfo;
        this.weightAttribute = weightAttribute;
        this.isWeighted = isWeighted;
        try {
            this.outputBINFile = new RandomAccessFile(outputFile, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            this.createBINFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
        this.addEdge(sourceNode, targetNode, attributes);
    }

    public void addUndirectedEdge(int sourceNode, int targetNode, Map attributes) {
        this.addEdge(sourceNode, targetNode, attributes);
    }

    public void finishedParsing() {
        try {
            this.outputBINFile.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean haltParsingNow() {
        return this.shouldHaltParsing;
    }

    private void addEdge(int sourceNodeID, int targetNodeID, Map attributes) {
        int weight = this.fetchNormalizedWeight(attributes);
        if ((double)weight < 0.0) {
            this.shouldHaltParsing = true;
        } else {
            Node sourceNode = this.networkInfo.findNodeByOriginalID(sourceNodeID);
            Node targetNode = this.networkInfo.findNodeByOriginalID(targetNodeID);
            try {
                this.writeEdgeAndWeightForNode(sourceNode, targetNode, weight);
                this.writeEdgeAndWeightForNode(targetNode, sourceNode, weight);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private int fetchNormalizedWeight(Map attributes) {
        double weight = this.isWeighted ? ((Number)attributes.get(this.weightAttribute)).doubleValue() : 1.0;
        double normalizedWeight = weight / this.networkInfo.getMaximumWeight();
        int fixedWeight = (int)(normalizedWeight * 1.0E7);
        return fixedWeight;
    }

    private void writeEdgeAndWeightForNode(Node sourceNode, Node targetNode, int weight) throws IOException {
        this.outputBINFile.seek(sourceNode.getWorkingEdgeOffsetInFile());
        this.writeProperInt(targetNode.getNewID());
        sourceNode.incrementWorkingEdgeOffsetInFile();
        this.outputBINFile.seek(sourceNode.getWorkingWeightOffsetInFile());
        this.writeProperInt(weight);
        sourceNode.incrementWorkingWeightOffsetInFile();
    }

    private void createBINFile() throws IOException {
        long headerSize = this.writeHeader();
        this.writeEmptyBody(headerSize);
    }

    private long writeHeader() throws IOException {
        long headerSize = 0L;
        ArrayList<Node> nodes = this.networkInfo.getNodes();
        int nodeCount = nodes.size();
        headerSize += (long)this.writeProperInt(nodeCount);
        int ii = 0;
        while (ii < nodeCount) {
            Node node = nodes.get(ii);
            headerSize += (long)this.writeProperInt(node.getEdgeCountForOutput());
            ++ii;
        }
        return headerSize;
    }

    private void writeEmptyBody(long headerSize) throws IOException {
        int jj;
        Node node;
        long numBytesWritten = headerSize;
        ArrayList<Node> nodes = this.networkInfo.getNodes();
        int nodeCount = nodes.size();
        int ii = 0;
        while (ii < nodeCount) {
            node = nodes.get(ii);
            node.setStartingEdgeOffsetInFile(numBytesWritten);
            jj = 0;
            while (jj < node.getActualEdgeCount()) {
                numBytesWritten += (long)this.writeProperInt(0);
                ++jj;
            }
            ++ii;
        }
        ii = 0;
        while (ii < nodeCount) {
            node = nodes.get(ii);
            node.setStartingWeightOffsetInFile(numBytesWritten);
            jj = 0;
            while (jj < node.getActualEdgeCount()) {
                numBytesWritten += (long)this.writeProperInt(0);
                ++jj;
            }
            ++ii;
        }
    }

    private int writeProperInt(int bigEndianInt) throws IOException {
        byte firstByte = (byte)(0xFF & bigEndianInt);
        byte secondByte = (byte)(0xFF & bigEndianInt >> 8);
        byte thirdByte = (byte)(0xFF & bigEndianInt >> 16);
        byte fourthByte = (byte)(0xFF & bigEndianInt >> 24);
        if (this.platformUsesLittleEndian()) {
            this.outputBINFile.writeByte(firstByte);
            this.outputBINFile.writeByte(secondByte);
            this.outputBINFile.writeByte(thirdByte);
            this.outputBINFile.writeByte(fourthByte);
        } else {
            this.outputBINFile.writeByte(fourthByte);
            this.outputBINFile.writeByte(thirdByte);
            this.outputBINFile.writeByte(secondByte);
            this.outputBINFile.writeByte(firstByte);
        }
        return 4;
    }

    private boolean platformUsesLittleEndian() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    }
}

