/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.burst;

import edu.iu.nwb.analysis.burst.BurstException;
import edu.iu.nwb.analysis.burst.Cell;
import edu.iu.nwb.analysis.burst.Result;
import edu.iu.nwb.analysis.burst.bins.WordBin;
import edu.iu.nwb.analysis.burst.bins.WordBins;
import edu.iu.nwb.analysis.burst.bins.WordBinsGenerator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Schema;
import prefuse.data.Table;

public class Burst
implements Algorithm {
    public static final int MIN_SLENGTH = 0;
    public static final double POWER_THRESH = 0.0;
    public static final double HUGEN = 1000000.0;
    public static final double DTRANS = 1.0;
    private double gamma = 1.0;
    private int inputStates = 1;
    private double densityScaling = 2.0;
    private LogService logger;
    private Data[] data;
    private Dictionary<String, Object> parameters;

    public Burst(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        String dateColumnTitle = (String)this.parameters.get("date");
        String textColumnTitle = (String)this.parameters.get("text");
        this.inputStates = (Integer)this.parameters.get("states");
        this.densityScaling = (Double)this.parameters.get("ratio");
        this.gamma = (Double)this.parameters.get("gamma");
        Table data = (Table)this.data[0].getData();
        this.checkForDateMasking(data, dateColumnTitle);
        this.checkColumns(data, dateColumnTitle, textColumnTitle);
        Table results = this.createResultTable();
        WordBinsGenerator wordBinsGenerator = new WordBinsGenerator(this.logger, data, this.parameters);
        try {
            WordBins wordBins = wordBinsGenerator.generateWordBins();
            int binSize = wordBins.getBinSize();
            for (String word : wordBins.getWordSet()) {
                WordBin wordBin = wordBins.getWordBin(word);
                Cell[] cells = this.computeStates(binSize, wordBin.getBin(), wordBins.getBinDocumentCount());
                int i = 0;
                while (i < binSize) {
                    Cell currentCell = cells[i];
                    int level = currentCell.getCandidates().length - 2;
                    while (level >= 0) {
                        if (this.isValidBurstCandidate(currentCell, level, i)) {
                            Result result = this.generateResult(currentCell, word, level, i, wordBins);
                            if (result.getEnd() != "" && result.getEnd().length() == 4) {
                                int cfr_ignored_0 = Integer.parseInt(result.getEnd()) - Integer.parseInt(result.getStart());
                            }
                            this.logger.log(3, String.valueOf(word) + " starts: " + result.getStart() + " ends: " + result.getEnd());
                            int row = results.addRow();
                            results.setString(row, "Word", result.getWord());
                            results.setDouble(row, "Weight", result.getWeight());
                            results.setInt(row, "Length", result.getLength());
                            results.setInt(row, "Level", result.getLevel());
                            results.setString(row, "Start", result.getStart());
                            results.setString(row, "End", result.getEnd());
                        }
                        --level;
                    }
                    ++i;
                }
            }
        }
        catch (BurstException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new AlgorithmExecutionException("There is not enough memory to handle such a big number of batches. Here are some suggestions:\ni) Increase the Java virtual machine's memory size until it can support the number of batches that needed. Please refer to [url]http://sci2.wiki.cns.iu.edu/3.4+Memory+Allocation[/url] for the memory allocation guidance.\nii) Adjust the 'Batch By' option to the longer batch option such as 'Month' and 'Year', so that the number of batches would be decreased.");
        }
        if (results.getRowCount() == 0) {
            this.logger.log(4, "No burst was detected. This may not be an error; the input data might not contain any bursts. Here are some suggestions:\ni) Adjust the 'Batch By' option, so that each bin will contain multiple documents.\nii) Tokenize your text column by using the 'Lowercase, Tokenize, Stem, and Stopword Text' algorithm in the Preprocessing menu and re-run the burst detection algorithm on the new dataset.\niii) More information and guides are available at [url]http://wiki.cns.iu.edu/display/CISHELL/Burst+Detection[/url].\niv) Contact us to report your problem.");
        }
        BasicData output = new BasicData((Object)results, Table.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "Burst detection analysis (" + dateColumnTitle + ", " + textColumnTitle + "): maximum burst level " + this.inputStates);
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Matrix");
        return new Data[]{output};
    }

    private Table createResultTable() {
        Schema resultsSchema = new Schema(new String[]{"Word", "Level", "Weight", "Length", "Start", "End"}, new Class[]{String.class, Integer.TYPE, Double.TYPE, Integer.TYPE, String.class, String.class});
        return resultsSchema.instantiate();
    }

    private Result generateResult(Cell cell, String word, int level, int startIndex, WordBins wordBins) {
        String startString = wordBins.getDateStringByIndex(startIndex);
        int binSize = wordBins.getBinSize();
        int endIndex = cell.getBreakpoints()[level];
        String endString = endIndex < binSize - 1 ? wordBins.getDateStringByIndex(--endIndex) : "";
        int length = endIndex - startIndex + 1;
        int state = this.inputStates - level;
        return new Result(word, state, cell.getTotalPowers()[level], length, startString, endString);
    }

    private boolean isValidBurstCandidate(Cell currentCell, int level, int binIndex) {
        return currentCell.getCandidates()[level] && currentCell.getBreakpoints()[level] - binIndex + 1 >= 0 && currentCell.getTotalPowers()[level] >= 0.0;
    }

    private void checkColumns(Table data, String dateColumn, String textColumn) throws AlgorithmExecutionException {
        this.checkForColumn(data, dateColumn);
        this.checkForColumn(data, textColumn);
    }

    private void checkForColumn(Table data, String dateColumn) throws AlgorithmExecutionException {
        if (!data.canGetString(dateColumn)) {
            throw new AlgorithmExecutionException("The column '" + dateColumn + "' does not exist or cannot be accessed as a string.");
        }
    }

    private void checkForDateMasking(Table data, String dateColumn) throws AlgorithmExecutionException {
        String enteredDate = (String)this.parameters.get("format");
        String datetest = data.getString(0, dateColumn);
        if (enteredDate.equals("MM/dd/yyyy") && datetest.length() == 7) {
            throw new AlgorithmExecutionException("The date format MM/dd/yyyy is masked as MM/dd/yy in your excel.Please select the date format as MM/dd/yy to execute the burst algorithm on your data'");
        }
    }

    private void checkDateFormats(Table data, String dateColumn) {
        SimpleDateFormat df = new SimpleDateFormat((String)this.parameters.get("format"));
        String dateStringtest = data.getString(0, dateColumn);
        try {
            Date mydate = df.parse(dateStringtest);
            this.logger.log(3, "Date read from table : " + dateStringtest);
            this.logger.log(3, "Date after parsing based on entered date format: " + mydate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private Cell[] computeStates(int n, int[] entry, int[] binBase) throws BurstException {
        double transCost = this.computeTransCost(n);
        int levels = this.inputStates + 1;
        Cell[] cells = this.computeCosts(n, levels, entry, binBase);
        int q = this.computeTotals(cells, n, transCost, levels);
        this.computePathAndMark(cells, n, levels, q);
        int[] leftBarrier = new int[levels];
        int k = 0;
        while (k < levels) {
            leftBarrier[k] = -1;
            ++k;
        }
        int j = 0;
        while (j < n) {
            Cell barrierCell;
            Cell currentCell = cells[j];
            int k2 = 0;
            while (k2 < levels - 1) {
                if (currentCell.getMarks()[k2]) {
                    leftBarrier[k2] = j;
                }
                ++k2;
            }
            k2 = 0;
            while (k2 < currentCell.getPath()) {
                if (leftBarrier[k2] >= 0) {
                    barrierCell = cells[leftBarrier[k2]];
                    barrierCell.getBreakpoints()[k2] = j;
                    barrierCell.getCandidates()[k2] = true;
                    currentCell.getEndCandidates()[k2] = 1;
                    leftBarrier[k2] = -1;
                }
                ++k2;
            }
            k2 = currentCell.getPath();
            while (k2 < levels - 1) {
                if (leftBarrier[k2] >= 0) {
                    barrierCell = cells[leftBarrier[k2]];
                    double[] dArray = barrierCell.getPowers();
                    int n2 = k2;
                    dArray[n2] = dArray[n2] + (currentCell.getCosts()[k2 + 1] - currentCell.getCosts()[k2]);
                    double[] dArray2 = barrierCell.getTotalPowers();
                    int n3 = k2;
                    dArray2[n3] = dArray2[n3] + (currentCell.getCosts()[levels - 1] - currentCell.getCosts()[k2]);
                }
                ++k2;
            }
            ++j;
        }
        Cell lastCell = cells[n - 1];
        int k3 = 0;
        while (k3 < levels - 1) {
            if (leftBarrier[k3] >= 0) {
                Cell barrierCell = cells[leftBarrier[k3]];
                barrierCell.getBreakpoints()[k3] = n - 1;
                barrierCell.getCandidates()[k3] = true;
                lastCell.getEndCandidates()[k3] = 1;
                leftBarrier[k3] = -1;
            }
            ++k3;
        }
        int j2 = 0;
        while (j2 < n - 1) {
            Cell currentCell = cells[j2];
            int p = -1;
            q = -1;
            int k4 = 0;
            while (k4 < levels - 1) {
                if (currentCell.getCandidates()[k4]) {
                    p = k4;
                    if (q < 0) {
                        q = k4;
                    }
                }
                ++k4;
            }
            if (p >= 0) {
                currentCell.setMinRateClass(q);
                k4 = 0;
                while (k4 < p) {
                    if (currentCell.getCandidates()[k4]) {
                        currentCell.getSubordinates()[k4] = true;
                    }
                    ++k4;
                }
            }
            ++j2;
        }
        return cells;
    }

    private Cell[] computeCosts(int n, int levels, int[] entry, int[] binBase) throws BurstException {
        double expected = this.computeExpected(n, entry, binBase);
        double[] fRate = this.initializeFRate(expected, levels);
        Cell[] cells = new Cell[n];
        int j = 0;
        while (j < n) {
            Cell cell;
            cells[j] = cell = new Cell(levels);
            int k = 0;
            while (k < levels) {
                cell.getCosts()[k] = this.binomW(1.0 / fRate[k], entry[j], binBase[j]);
                ++k;
            }
            ++j;
        }
        return cells;
    }

    private int computeTotals(Cell[] cells, int n, double transCost, int levels) {
        Cell firstCell = cells[0];
        Cell lastCell = cells[n - 1];
        int k = 0;
        while (k < levels) {
            firstCell.getTotals()[k] = firstCell.getCosts()[k] + transCost * (double)(levels - 1 - k);
            ++k;
        }
        int j = 1;
        while (j < n) {
            Cell currentCell = cells[j];
            Cell previousCell = cells[j - 1];
            int k2 = 0;
            while (k2 < levels) {
                double d = currentCell.getCosts()[k2] + previousCell.getTotals()[0];
                int q = 0;
                int m = 1;
                while (m < levels) {
                    double tmpD = currentCell.getCosts()[k2] + previousCell.getTotals()[m];
                    if (m > k2 && tmpD + transCost * (double)(m - k2) <= d) {
                        d = tmpD + transCost * (double)(m - k2);
                        q = m;
                    } else if (m <= k2 && tmpD <= d) {
                        d = tmpD;
                        q = m;
                    }
                    ++m;
                }
                currentCell.getTotals()[k2] = d;
                currentCell.getPreviousPaths()[k2] = q;
                ++k2;
            }
            ++j;
        }
        int q = 0;
        int k3 = 0;
        while (k3 < levels) {
            double d = lastCell.getTotals()[0];
            q = 0;
            int m = 1;
            while (m < levels) {
                if (lastCell.getTotals()[m] < d) {
                    d = lastCell.getTotals()[m];
                    q = m;
                }
                ++m;
            }
            ++k3;
        }
        return q;
    }

    private void computePathAndMark(Cell[] cells, int n, int levels, int q) {
        Cell firstCell = cells[0];
        Cell lastCell = cells[n - 1];
        lastCell.setPath(q);
        int j = n - 2;
        while (j >= 0) {
            Cell nextCell = cells[j + 1];
            Cell currentCell = cells[j];
            currentCell.setPath(nextCell.getPreviousPaths()[nextCell.getPath()]);
            --j;
        }
        int k = firstCell.getPath();
        while (k < levels - 1) {
            firstCell.getMarks()[k] = true;
            ++k;
        }
        j = 1;
        while (j < n) {
            Cell currentCell = cells[j];
            Cell previousCell = cells[j - 1];
            int k2 = currentCell.getPath();
            while (k2 < previousCell.getPath()) {
                currentCell.getMarks()[k2] = true;
                ++k2;
            }
            ++j;
        }
    }

    private double[] initializeFRate(double expected, int levels) {
        double[] fRate = new double[levels];
        fRate[levels - 1] = expected;
        int j = levels - 2;
        while (j >= 0) {
            fRate[j] = fRate[j + 1] / this.densityScaling;
            --j;
        }
        return fRate;
    }

    private double computeTransCost(int n) {
        double transCost = this.gamma * Math.log(n + 1) - Math.log(1.0);
        if (transCost < 0.0) {
            transCost = 0.0;
        }
        return transCost;
    }

    private double computeExpected(int n, int[] entry, int[] binBase) throws BurstException {
        int binN = 0;
        int binK = 0;
        int i = 0;
        while (i < n) {
            binK += entry[i];
            binN += binBase[i];
            ++i;
        }
        if (binN == 0 || binK == 0) {
            throw new BurstException("A word bursted on is never used; this should be impossible, please notify the algorithm author");
        }
        double expected = (double)binN / (double)binK;
        return expected;
    }

    private double logChoose(int n, int k) {
        double value = 0.0;
        int index = n;
        while (index > n - k) {
            value += Math.log(index);
            --index;
        }
        index = 1;
        while (index <= k) {
            value -= Math.log(index);
            ++index;
        }
        return value;
    }

    private double binomW(double probability, int k, int n) {
        if (probability >= 1.0) {
            return 1000000.0;
        }
        return -1.0 * (this.logChoose(n, k) + (double)k * Math.log(probability) + (double)(n - k) * Math.log(1.0 - probability));
    }
}

