/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.burst;

import edu.iu.nwb.analysis.burst.Burst;
import edu.iu.nwb.analysis.burst.Constants;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Schema;
import prefuse.data.Table;

public class BurstFactory
implements AlgorithmFactory,
ParameterMutator {
    protected static final String NO_DOCUMENT_COLUMN_VALUE = "No document column.";
    public static final int ICON_SIZE = 16;

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        return new Burst(data, parameters, context);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        BasicObjectClassDefinition definition;
        Table t = (Table)data[0].getData();
        ObjectClassDefinition oldDefinition = parameters;
        try {
            definition = new BasicObjectClassDefinition(oldDefinition.getID(), oldDefinition.getName(), oldDefinition.getDescription(), oldDefinition.getIcon(16));
        }
        catch (IOException iOException) {
            definition = new BasicObjectClassDefinition(oldDefinition.getID(), oldDefinition.getName(), oldDefinition.getDescription(), null);
        }
        String[] columnValues = this.createKeyArray(t.getSchema());
        AttributeDefinition[] definitions = oldDefinition.getAttributeDefinitions(-1);
        int ii = 0;
        while (ii < definitions.length) {
            AttributeDefinition attribute = definitions[ii];
            String id = attribute.getID();
            if ("date".equals(id) || "text".equals(id)) {
                definition.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(id, attribute.getName(), attribute.getDescription(), attribute.getType(), columnValues, columnValues));
            } else if ("document".equals(id)) {
                columnValues = this.addNoColumnOption(columnValues, NO_DOCUMENT_COLUMN_VALUE);
                definition.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(id, attribute.getName(), attribute.getDescription(), attribute.getType(), columnValues, columnValues));
            } else if ("batchBy".equals(id)) {
                definition.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(id, attribute.getName(), attribute.getDescription(), attribute.getType(), Constants.BATCHED_BY_OPTIONS, Constants.BATCHED_BY_OPTIONS));
            } else {
                definition.addAttributeDefinition(1, attribute);
            }
            ++ii;
        }
        return definition;
    }

    private String[] addNoColumnOption(String[] columnNames, String noColumnDescriptor) {
        String[] withNoColumn = new String[columnNames.length + 1];
        withNoColumn[0] = noColumnDescriptor;
        int ii = 0;
        while (ii < columnNames.length) {
            withNoColumn[ii + 1] = columnNames[ii];
            ++ii;
        }
        return withNoColumn;
    }

    private String[] createKeyArray(Schema schema) {
        String[] keys = new String[schema.getColumnCount()];
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            keys[ii] = schema.getColumnName(ii);
            ++ii;
        }
        return keys;
    }
}

