/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.burst.batcher;

import edu.iu.nwb.analysis.burst.batcher.Batcher;
import java.util.Date;
import org.joda.time.DateTime;

public abstract class AbstractBatcher
implements Batcher {
    private DateTime startDate;
    private DateTime endDate;
    private int size;
    private int batchByUnits;

    public AbstractBatcher(Date startDate, Date endDate, int batchByUnits) {
        this.startDate = this.getDateTime(startDate);
        this.endDate = this.getDateTime(endDate);
        this.setBatchByUnits(batchByUnits);
        this.setSize(batchByUnits);
    }

    @Override
    public String getDateStringByIndex(int index) {
        int distance = index * this.batchByUnits;
        return this.getDateStringByDistance(distance);
    }

    @Override
    public int getIndexByDate(Date date) {
        return this.getDistanceByDate(date) / this.batchByUnits;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private void setBatchByUnits(int batchByUnits) {
        this.batchByUnits = Math.max(1, batchByUnits);
    }

    private void setSize(int batchByUnits) {
        int size = this.generateBatcherSize();
        if (batchByUnits > 0) {
            this.size = size / batchByUnits;
            if (size % batchByUnits > 0) {
                ++this.size;
            }
        } else {
            this.size = size;
        }
    }

    protected abstract DateTime getDateTime(Date var1);

    protected abstract String getDateStringByDistance(int var1);

    protected abstract int getDistanceByDate(Date var1);

    protected abstract int generateBatcherSize();
}

