/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.burst.batcher;

import edu.iu.nwb.analysis.burst.batcher.AbstractBatcher;
import edu.iu.nwb.analysis.burst.batcher.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;

public class BatchByDay
extends AbstractBatcher {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy");

    public BatchByDay(Date startDate, Date endDate, int batchByUnits) {
        super(startDate, endDate, batchByUnits);
    }

    @Override
    protected DateTime getDateTime(Date date) {
        DateTime datetime = new DateTime((Object)date);
        return new DateTime(datetime.getYear(), datetime.getMonthOfYear(), datetime.getDayOfMonth(), 0, 0, 0, 0);
    }

    @Override
    protected String getDateStringByDistance(int distance) {
        return DATE_FORMAT.format(DateTimeUtils.addDays(this.getStartDate(), distance).toDate());
    }

    @Override
    protected int getDistanceByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTimeUtils.getDaysDifferent(this.getStartDate(), new DateTime((Object)date));
    }

    @Override
    protected int generateBatcherSize() {
        return DateTimeUtils.getDaysDifferent(this.getStartDate(), this.getEndDate()) + 1;
    }
}

