/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.burst.batcher;

import edu.iu.nwb.analysis.burst.batcher.BatchByDay;
import edu.iu.nwb.analysis.burst.batcher.BatchByHour;
import edu.iu.nwb.analysis.burst.batcher.BatchByMinute;
import edu.iu.nwb.analysis.burst.batcher.BatchByMonth;
import edu.iu.nwb.analysis.burst.batcher.BatchByYear;
import edu.iu.nwb.analysis.burst.batcher.Batcher;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum BatchFactory {
    YEARS("Years"){

        @Override
        public Batcher getBatcher(Date startDate, Date endDate, int batchLength) {
            return new BatchByYear(startDate, endDate, batchLength);
        }
    }
    ,
    MONTHS("Months"){

        @Override
        public Batcher getBatcher(Date startDate, Date endDate, int batchLength) {
            return new BatchByMonth(startDate, endDate, batchLength);
        }
    }
    ,
    DAYS("Days"){

        @Override
        public Batcher getBatcher(Date startDate, Date endDate, int batchLength) {
            return new BatchByDay(startDate, endDate, batchLength);
        }
    }
    ,
    HOURS("Hours"){

        @Override
        public Batcher getBatcher(Date startDate, Date endDate, int batchLength) {
            return new BatchByHour(startDate, endDate, batchLength);
        }
    }
    ,
    MINUTES("Minutes"){

        @Override
        public Batcher getBatcher(Date startDate, Date endDate, int batchLength) {
            return new BatchByMinute(startDate, endDate, batchLength);
        }
    };

    public static final Map<String, BatchFactory> NAME_TO_BATCH_FACTORY;
    private String userFriendlyName;

    static {
        NAME_TO_BATCH_FACTORY = new HashMap<String, BatchFactory>();
        BatchFactory[] batchFactoryArray = BatchFactory.values();
        int n = batchFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            BatchFactory batchFactory = batchFactoryArray[n2];
            NAME_TO_BATCH_FACTORY.put(batchFactory.getUserFriendlyName(), batchFactory);
            ++n2;
        }
    }

    private BatchFactory(String userFriendlyName) {
        this.userFriendlyName = userFriendlyName;
    }

    public static BatchFactory getBatchFactory(String userFriendlyName) {
        return NAME_TO_BATCH_FACTORY.get(userFriendlyName);
    }

    public static String[] userFriendlyNames() {
        BatchFactory[] values = BatchFactory.values();
        String[] stringValues = new String[values.length];
        int i = 0;
        BatchFactory[] batchFactoryArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BatchFactory value = batchFactoryArray[n2];
            stringValues[i++] = value.getUserFriendlyName();
            ++n2;
        }
        return stringValues;
    }

    public abstract Batcher getBatcher(Date var1, Date var2, int var3);

    public String getUserFriendlyName() {
        return this.userFriendlyName;
    }

    /* synthetic */ BatchFactory(String string, int n, String string2, BatchFactory batchFactory) {
        this(string2);
    }
}

