/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.burst.batcher;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.Years;

public final class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static int getYearsDifferent(DateTime startDate, DateTime endDate) {
        return Math.abs(Years.yearsBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getYears());
    }

    public static int getMonthsDifferent(DateTime startDate, DateTime endDate) {
        return Math.abs(Months.monthsBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getMonths());
    }

    public static int getDaysDifferent(DateTime startDate, DateTime endDate) {
        return Math.abs(Days.daysBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getDays());
    }

    public static int getHoursDifferent(DateTime startDate, DateTime endDate) {
        return Math.abs(Hours.hoursBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getHours());
    }

    public static int getMinutesDifferent(DateTime startDate, DateTime endDate) {
        return Math.abs(Minutes.minutesBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getMinutes());
    }

    public static int getSecondsDifferent(DateTime startDate, DateTime endDate) {
        return Math.abs(Seconds.secondsBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getSeconds());
    }

    public static DateTime addYears(DateTime dateTime, int years) {
        return dateTime.plusYears(years);
    }

    public static DateTime addMonths(DateTime dateTime, int months) {
        return dateTime.plusMonths(months);
    }

    public static DateTime addDays(DateTime dateTime, int days) {
        return dateTime.plusDays(days);
    }

    public static DateTime addHours(DateTime dateTime, int hours) {
        return dateTime.plusHours(hours);
    }

    public static DateTime addMinutes(DateTime dateTime, int minutes) {
        return dateTime.plusMinutes(minutes);
    }

    public static DateTime addSeconds(DateTime dateTime, int seconds) {
        return dateTime.plusSeconds(seconds);
    }
}

