/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.burst.bins;

import edu.iu.nwb.analysis.burst.BurstException;
import edu.iu.nwb.analysis.burst.DocumentRetriever;
import edu.iu.nwb.analysis.burst.DocumentRetrieverFactory;
import edu.iu.nwb.analysis.burst.batcher.BatchFactory;
import edu.iu.nwb.analysis.burst.bins.WordBins;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashSet;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class WordBinsGenerator {
    public static final SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy");
    private String textColumnTitle;
    private String textSeparator;
    private String documentColumnTitle;
    private String dateColumnTitle;
    private String batchBy;
    private SimpleDateFormat dateFormat;
    private Table data;
    private LogService logger;
    private boolean ignoreEmpty;
    private int batchByUnits = 1;

    public WordBinsGenerator(LogService logger, Table data, Dictionary<String, Object> parameters) {
        this.logger = logger;
        this.data = data;
        this.documentColumnTitle = (String)parameters.get("document");
        this.textColumnTitle = (String)parameters.get("text");
        this.textSeparator = (String)parameters.get("separator");
        this.dateColumnTitle = (String)parameters.get("date");
        this.dateFormat = new SimpleDateFormat((String)parameters.get("format"));
        this.batchBy = (String)parameters.get("batchBy");
        this.ignoreEmpty = (Boolean)parameters.get("ignore");
        this.setBatchByUnits((Integer)parameters.get("batchByUnits"));
    }

    public WordBins generateWordBins() throws BurstException {
        WordBins wordBins = this.createWordBins();
        this.generateWordBinsEntries(wordBins);
        return wordBins;
    }

    private void generateWordBinsEntries(WordBins wordBins) {
        HashSet<Object> documents = new HashSet<Object>();
        DocumentRetriever retriever = DocumentRetrieverFactory.createForColumn(this.documentColumnTitle);
        int row = 0;
        while (row < this.data.getRowCount()) {
            String dateString = this.data.getString(row, this.dateColumnTitle);
            if (dateString != null && dateString.length() > 0) {
                String text = this.data.getString(row, this.textColumnTitle);
                Collection<String> words = this.extractUniqueWords(text, this.textSeparator);
                if (!this.ignoreEmpty || words.size() != 0) {
                    try {
                        Object documentId = retriever.retrieve(this.data, row, this.documentColumnTitle);
                        if (documentId == null || !documents.contains(documentId)) {
                            if (documentId != null) {
                                documents.add(documentId);
                            }
                            Date date = this.dateFormat.parse(dateString);
                            wordBins.addADocument(words, date);
                        }
                    }
                    catch (ParseException e) {
                        this.logger.log(2, "Problems parsing value " + dateString + ", verify the given date format '" + this.dateFormat.toLocalizedPattern() + "' matches format in file.", (Throwable)e);
                    }
                }
            }
            ++row;
        }
    }

    private WordBins createWordBins() throws BurstException {
        WordBins wordBins;
        Date startDate = null;
        Date endDate = null;
        String dateStringExample = null;
        int row = 0;
        while (row < this.data.getRowCount()) {
            block13: {
                String dateString = this.data.getString(row, this.dateColumnTitle);
                if (dateString != null && dateString.length() > 0) {
                    try {
                        Date date = this.dateFormat.parse(dateString);
                        if (startDate == null) {
                            startDate = date;
                            endDate = date;
                        } else if (date.after(endDate)) {
                            endDate = date;
                        } else if (date.before(startDate)) {
                            startDate = date;
                        }
                    }
                    catch (ParseException parseException) {
                        if (dateStringExample != null) break block13;
                        Date today = new Date();
                        dateStringExample = this.dateFormat.format(today);
                    }
                }
            }
            ++row;
        }
        if (startDate == null || endDate == null) {
            String errorMsg = "No valid date is found. Please make sure the given date format '" + this.dateFormat.toLocalizedPattern() + "' matches the date format of the selected date column.";
            if (dateStringExample != null) {
                errorMsg = String.valueOf(errorMsg) + " An example date value is '" + dateStringExample + "'.";
            }
            errorMsg = String.valueOf(errorMsg) + " More information are available at [url]http://docs.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html[/url].";
            throw new BurstException(errorMsg);
        }
        try {
            wordBins = new WordBins(BatchFactory.getBatchFactory(this.batchBy).getBatcher(startDate, endDate, this.batchByUnits));
        }
        catch (ArithmeticException e) {
            throw new OutOfMemoryError(e.getMessage());
        }
        return wordBins;
    }

    private Collection<String> extractUniqueWords(String text, String separator) {
        HashSet<String> wordSet = new HashSet<String>();
        if (text != null) {
            String[] strings;
            String[] stringArray = strings = text.split("\\" + separator);
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if ((word = word.trim()).length() > 0) {
                    wordSet.add(word);
                }
                ++n2;
            }
        }
        return wordSet;
    }

    private void setBatchByUnits(int batchByUnits) {
        this.batchByUnits = Math.max(1, batchByUnits);
    }
}

