/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.communitydetection.slm.convertor;

import edu.iu.nwb.analysis.communitydetection.slm.convertor.NetworkInfo;
import edu.iu.nwb.analysis.communitydetection.slm.convertor.Node;
import edu.iu.nwb.analysis.communitydetection.slm.convertor.TreeFileParsingException;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.cishell.utilities.SetUtilities;

public class Merger
extends NWBFileWriter {
    public static final String BASE_COMMUNITY_LEVEL_ATTRIBUTE_NAME = "community_level_";
    public static final String BASE_COMMUNITY_LABEL = "community_";
    public static final String BASE_ISOLATE_LABEL = "isolate_";
    private NetworkInfo networkInfo;
    private int isolateCount = 0;

    public Merger(File treeFile, File outputFile, NetworkInfo networkInfo) throws FileNotFoundException, IOException, TreeFileParsingException {
        super(outputFile);
        this.networkInfo = networkInfo;
        this.readTreeFileAndAnnotateNodes(new Scanner(treeFile));
    }

    public void addNode(int id, String label, Map<String, Object> attributes) {
        Node node = this.networkInfo.findNodeByOriginalID(id);
        HashMap<String, Object> annotatedAttributes = new HashMap<String, Object>();
        annotatedAttributes.putAll(attributes);
        if (node != null) {
            ArrayList<Integer> nodeCommunities = node.getCommunities();
            int ii = 0;
            while (ii < nodeCommunities.size()) {
                String communityLevelAttributeName = BASE_COMMUNITY_LEVEL_ATTRIBUTE_NAME + ii;
                String communityName = BASE_COMMUNITY_LABEL + nodeCommunities.get(ii);
                annotatedAttributes.put(communityLevelAttributeName, communityName);
                ++ii;
            }
        } else {
            int ii = 0;
            while (ii < this.networkInfo.getMaxCommunityLevel()) {
                String communityLevelAttributeName = BASE_COMMUNITY_LEVEL_ATTRIBUTE_NAME + ii;
                String communityName = BASE_ISOLATE_LABEL + this.isolateCount;
                annotatedAttributes.put(communityLevelAttributeName, communityName);
                ++this.isolateCount;
                ++ii;
            }
        }
        super.addNode(id, label, annotatedAttributes);
    }

    public void setNodeSchema(LinkedHashMap<String, String> schema) {
        int ii = 0;
        while (ii < this.networkInfo.getMaxCommunityLevel()) {
            String communityLevelAttributeName = BASE_COMMUNITY_LEVEL_ATTRIBUTE_NAME + ii;
            schema.put(communityLevelAttributeName, "string");
            ++ii;
        }
        super.setNodeSchema(schema);
    }

    private void readTreeFileAndAnnotateNodes(Scanner treeFileScanner) throws TreeFileParsingException {
        HashMap<Integer, Integer> previousMap = null;
        HashMap<Integer, Integer> currentMap = null;
        ArrayList<Node> nodes = this.networkInfo.getNodes();
        boolean shouldKeepReading = true;
        while (shouldKeepReading) {
            if (!this.checkForAnotherEntry(treeFileScanner)) {
                shouldKeepReading = false;
                continue;
            }
            Integer nodeID = this.readNextNodeID(treeFileScanner);
            Integer communityID = this.readNextCommunityID(treeFileScanner);
            if (nodeID == 0) {
                previousMap = currentMap;
                currentMap = new HashMap<Integer, Integer>();
            }
            if (previousMap != null) {
                Collection nodesInCommunity = SetUtilities.getKeysOfMapEntrySetWithValue(previousMap.entrySet(), (Object)nodeID);
                for (Integer currentNodeID : nodesInCommunity) {
                    currentMap.put(currentNodeID, communityID);
                    Node node = nodes.get(currentNodeID);
                    node.addCommunity(communityID, this.networkInfo);
                }
                continue;
            }
            currentMap.put(nodeID, communityID);
            Node node = nodes.get(nodeID);
            node.addCommunity(communityID, this.networkInfo);
        }
    }

    private boolean checkForAnotherEntry(Scanner treeFileScanner) throws TreeFileParsingException {
        if (treeFileScanner.hasNext()) {
            if (!treeFileScanner.hasNextInt()) {
                throw new TreeFileParsingException("A non-integer was found.  Tree files must contain only pairs of integers.");
            }
            return true;
        }
        return false;
    }

    private Integer readNextNodeID(Scanner treeFileScanner) throws TreeFileParsingException {
        return new Integer(treeFileScanner.nextInt());
    }

    private Integer readNextCommunityID(Scanner treeFileScanner) throws TreeFileParsingException {
        if (!treeFileScanner.hasNext() || !treeFileScanner.hasNextInt()) {
            throw new TreeFileParsingException("A single integer was found.  Tree files must contain only pairs of integers.");
        }
        return new Integer(treeFileScanner.nextInt());
    }
}

