/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.communitydetection.slm.convertor;

import edu.iu.nwb.analysis.communitydetection.slm.convertor.Edge;
import edu.iu.nwb.analysis.communitydetection.slm.convertor.Node;
import java.util.ArrayList;

public class NetworkInfo {
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<Edge> edges = new ArrayList();
    private int maxCommunityLevel = 0;
    private int renumberingID = 0;
    private int totalEdgeCount = 0;
    private double maximumWeight = 0.0;

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public int getMaxCommunityLevel() {
        return this.maxCommunityLevel;
    }

    public int getRenumberingID() {
        return this.renumberingID;
    }

    public int getTotalEdgeCount() {
        return this.totalEdgeCount;
    }

    public double getMaximumWeight() {
        return this.maximumWeight;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void incrementRenumberingID() {
        ++this.renumberingID;
    }

    public void incrementTotalEdgeCount() {
        ++this.totalEdgeCount;
    }

    public void setMaxCommunityLevel(int maxCommunityLevel) {
        this.maxCommunityLevel = maxCommunityLevel;
    }

    public void setMaximumWeight(double maximumWeight) {
        this.maximumWeight = maximumWeight;
    }

    public Node findNodeByOriginalID(int originalID) {
        int nodeCount = this.nodes.size();
        if (originalID < 0) {
            return null;
        }
        int ii = 0;
        while (ii < nodeCount) {
            Node node = this.nodes.get(ii);
            if (node.getOriginalID() == originalID) {
                return node;
            }
            ++ii;
        }
        return null;
    }

    public void accumulateEdgeCountsForOutput() {
        int nodeCount = this.nodes.size();
        int edgeCountForOutput = 0;
        int ii = 0;
        while (ii < nodeCount) {
            Node node = this.nodes.get(ii);
            node.setEdgeCountForOutput(edgeCountForOutput += node.getActualEdgeCount());
            ++ii;
        }
    }
}

