/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.communitydetection.slm.vos;

import edu.iu.nwb.analysis.communitydetection.slm.vos.Network;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Scanner;

public class ModularityOptimizer {
    boolean printOutput = true;
    boolean update;
    double modularity;
    double maxModularity;
    double resolution;
    double resolution2;
    int algorithm;
    int i;
    int j;
    int nClusters;
    int nIterations;
    int nRandomStarts;
    int modularityFunction;
    long beginTime;
    long endTime;
    long randomSeed;
    Network network;
    Random random;

    public ModularityOptimizer(int algorithm, int modularityFunction, int randomStart, int randomSeed, int iterations, double resolution) {
        if (algorithm < 1 || algorithm > 3 || modularityFunction < 1 || modularityFunction > 2) {
            throw new IllegalArgumentException("The given parameters are invalid. The algorithm parameter should be between 1 to 3. The modularity function parameter should be between 1 to 2.");
        }
        this.resolution = resolution;
        this.algorithm = algorithm;
        this.nRandomStarts = randomStart;
        this.nIterations = iterations;
        this.randomSeed = randomSeed;
        this.modularityFunction = modularityFunction;
    }

    public ModularityOptimizer() {
        this.resolution = 1.0;
        this.algorithm = 3;
        this.nRandomStarts = 10;
        this.nIterations = 10;
        this.randomSeed = 0L;
        this.modularityFunction = 1;
    }

    public void OptimizeModularity(File inputFile, File outputFile) throws IOException {
        if (this.printOutput) {
            System.out.println("Modularity Optimizer version 1.1.0 by Ludo Waltman and Nees Jan van Eck");
        }
        this.network = ModularityOptimizer.readInputFile(inputFile, this.modularityFunction);
        if (this.printOutput) {
            System.out.format("Number of nodes: %d%n", this.network.getNNodes());
            System.out.format("Number of edges: %d%n", this.network.getNEdges() / 2);
            System.out.println();
            System.out.println("Running " + (this.algorithm == 1 ? "Louvain algorithm" : (this.algorithm == 2 ? "Louvain algorithm with multilevel refinement" : "smart local moving algorithm")) + "...");
            System.out.println();
        }
        this.resolution2 = this.modularityFunction == 1 ? this.resolution / this.network.getTotalEdgeWeight() : this.resolution;
        this.beginTime = System.currentTimeMillis();
        int[] cluster = null;
        this.nClusters = -1;
        this.maxModularity = Double.NEGATIVE_INFINITY;
        this.random = new Random(this.randomSeed);
        this.i = 0;
        while (this.i < this.nRandomStarts) {
            if (this.printOutput && this.nRandomStarts > 1) {
                System.out.format("Random start: %d%n", this.i + 1);
            }
            this.network.initSingletonClusters();
            this.j = 0;
            this.update = true;
            do {
                if (this.algorithm == 1) {
                    this.update = this.network.runLouvainAlgorithm(this.resolution2, this.random);
                } else if (this.algorithm == 2) {
                    this.update = this.network.runLouvainAlgorithmWithMultilevelRefinement(this.resolution2, this.random);
                } else if (this.algorithm == 3) {
                    this.network.runSmartLocalMovingAlgorithm(this.resolution2, this.random);
                }
                ++this.j;
            } while (this.j < this.nIterations && this.update);
            this.modularity = this.network.calcQualityFunction(this.resolution2);
            if (this.modularity > this.maxModularity) {
                this.network.orderClustersByNNodes();
                cluster = this.network.getClusters();
                this.nClusters = this.network.getNClusters();
                this.maxModularity = this.modularity;
            }
            if (this.printOutput && this.nRandomStarts > 1) {
                System.out.format("Modularity: %.4f%n", this.modularity);
                System.out.println();
            }
            ++this.i;
        }
        this.endTime = System.currentTimeMillis();
        ModularityOptimizer.writeOutputFile(outputFile, cluster);
        if (this.printOutput) {
            if (this.nRandomStarts == 1) {
                System.out.format("Modularity: %.4f%n", this.maxModularity);
            } else {
                System.out.format("Maximum modularity in %d random starts: %.4f%n", this.nRandomStarts, this.maxModularity);
            }
            System.out.format("Number of clusters: %d%n", this.nClusters);
            System.out.format("Elapsed time: %d seconds%n", Math.round((double)(this.endTime - this.beginTime) / 1000.0));
            System.out.println();
        }
    }

    private static Network readInputFile(File file, int modularityFunction) throws IOException {
        Network network;
        double edgeWeight;
        int node2;
        int node1;
        class Edge
        implements Comparable<Edge> {
            public int node1;
            public int node2;
            public double weight;

            public Edge(int node1, int node2, double weight) {
                this.node1 = node1;
                this.node2 = node2;
                this.weight = weight;
            }

            @Override
            public int compareTo(Edge edge) {
                return this.node1 == edge.node1 ? this.node2 - edge.node2 : this.node1 - edge.node1;
            }
        }
        ArrayList<Edge> edgeArrayList1 = new ArrayList<Edge>();
        Scanner fileScanner = null;
        try {
            fileScanner = new Scanner(new FileReader(file));
            while (fileScanner.hasNext()) {
                Scanner lineScanner = new Scanner(fileScanner.nextLine());
                node1 = lineScanner.nextInt();
                node2 = lineScanner.nextInt();
                double d = edgeWeight = lineScanner.hasNextDouble() ? lineScanner.nextDouble() : 1.0;
                if (node1 == node2) continue;
                edgeArrayList1.add(new Edge(node1, node2, edgeWeight));
                edgeArrayList1.add(new Edge(node2, node1, edgeWeight));
            }
        }
        finally {
            if (fileScanner != null) {
                fileScanner.close();
            }
        }
        Collections.sort(edgeArrayList1);
        ArrayList<Edge> edgeArrayList2 = new ArrayList<Edge>();
        node1 = -1;
        node2 = -1;
        edgeWeight = 0.0;
        int i = 0;
        while (i < edgeArrayList1.size()) {
            Edge edge = (Edge)edgeArrayList1.get(i);
            if (edge.node1 == node1 && edge.node2 == node2) {
                edgeWeight += edge.weight;
            } else {
                if (i > 0) {
                    edgeArrayList2.add(new Edge(node1, node2, edgeWeight));
                }
                node1 = edge.node1;
                node2 = edge.node2;
                edgeWeight = edge.weight;
            }
            ++i;
        }
        edgeArrayList2.add(new Edge(node1, node2, edgeWeight));
        int[][] edge2 = new int[edgeArrayList2.size()][2];
        double[] edgeWeight2 = new double[edgeArrayList2.size()];
        int i2 = 0;
        while (i2 < edgeArrayList2.size()) {
            Edge edge = (Edge)edgeArrayList2.get(i2);
            edge2[i2][0] = edge.node1;
            edge2[i2][1] = edge.node2;
            edgeWeight2[i2] = edge.weight;
            ++i2;
        }
        int nNodes = -1;
        int j = 0;
        while (j < edge2.length) {
            if (edge2[j][0] > nNodes) {
                nNodes = edge2[j][0];
            }
            ++j;
        }
        ++nNodes;
        if (modularityFunction == 1) {
            double[] nodeWeight = new double[nNodes];
            int i3 = 0;
            while (i3 < edge2.length) {
                int n = edge2[i3][0];
                nodeWeight[n] = nodeWeight[n] + edgeWeight2[i3];
                ++i3;
            }
            network = new Network(nNodes, edge2, edgeWeight2, nodeWeight);
        } else {
            network = new Network(nNodes, edge2, edgeWeight2);
        }
        return network;
    }

    private static void writeOutputFile(File file, int[] cluster) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            int i = 0;
            while (i < cluster.length) {
                bufferedWriter.write(String.valueOf(i) + " " + Integer.toString(cluster[i]));
                bufferedWriter.newLine();
                ++i;
            }
            bufferedWriter.close();
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }
}

