/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.communitydetection.slm.vos;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.Scanner;

public class Network
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int nNodes;
    private int[] firstNeighborIndex;
    private int[] neighbor;
    private double[] edgeWeight;
    private double totalEdgeWeightSelfLinks;
    private double[] nodeWeight;
    private int nClusters;
    private int[] cluster;
    private double[] clusterWeight;
    private int[] nNodesPerCluster;
    private int[][] nodePerCluster;
    private boolean clusteringStatsAvailable;

    public static Network load(String fileName) throws ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(fileName));
        Network network = (Network)objectInputStream.readObject();
        objectInputStream.close();
        return network;
    }

    public Network(int nNodes, int[][] edge) {
        this(nNodes, edge, null, null, null);
    }

    public Network(int nNodes, int[][] edge, double[] edgeWeight) {
        this(nNodes, edge, edgeWeight, null, null);
    }

    public Network(int nNodes, int[][] edge, double[] edgeWeight, double[] nodeWeight) {
        this(nNodes, edge, edgeWeight, nodeWeight, null);
    }

    public Network(int nNodes, int[][] edge, double[] edgeWeight, double[] nodeWeight, int[] cluster) {
        int i;
        this.nNodes = nNodes;
        int nEdges = edge.length;
        this.firstNeighborIndex = new int[nNodes + 1];
        if (edgeWeight == null) {
            edgeWeight = new double[nEdges];
            i = 0;
            while (i < nEdges) {
                edgeWeight[i] = 1.0;
                ++i;
            }
        }
        this.totalEdgeWeightSelfLinks = 0.0;
        int[] neighbor = new int[nEdges];
        double[] edgeWeight2 = new double[nEdges];
        i = 1;
        int nEdgesWithoutSelfLinks = 0;
        int j = 0;
        while (j < nEdges) {
            if (edge[j][0] == edge[j][1]) {
                this.totalEdgeWeightSelfLinks += edgeWeight[j];
            } else {
                if (edge[j][0] >= i) {
                    while (i <= edge[j][0]) {
                        this.firstNeighborIndex[i] = nEdgesWithoutSelfLinks;
                        ++i;
                    }
                }
                neighbor[nEdgesWithoutSelfLinks] = edge[j][1];
                edgeWeight2[nEdgesWithoutSelfLinks] = edgeWeight[j];
                ++nEdgesWithoutSelfLinks;
            }
            ++j;
        }
        while (i <= nNodes) {
            this.firstNeighborIndex[i] = nEdgesWithoutSelfLinks;
            ++i;
        }
        this.neighbor = new int[nEdgesWithoutSelfLinks];
        System.arraycopy(neighbor, 0, this.neighbor, 0, nEdgesWithoutSelfLinks);
        this.edgeWeight = new double[nEdgesWithoutSelfLinks];
        System.arraycopy(edgeWeight2, 0, this.edgeWeight, 0, nEdgesWithoutSelfLinks);
        if (nodeWeight == null) {
            this.nodeWeight = new double[nNodes];
            i = 0;
            while (i < nNodes) {
                this.nodeWeight[i] = 1.0;
                ++i;
            }
        } else {
            this.nodeWeight = nodeWeight;
        }
        this.setClusters(cluster);
    }

    public Network(int nNodes, String fileName) throws FileNotFoundException {
        this(nNodes, fileName, null, null);
    }

    public Network(int nNodes, String fileName, double[] nodeWeight) throws FileNotFoundException {
        this(nNodes, fileName, nodeWeight, null);
    }

    public Network(int nNodes, String fileName, double[] nodeWeight, int[] cluster) throws FileNotFoundException {
        this.nNodes = nNodes;
        Scanner fileScanner = new Scanner(new FileReader(fileName));
        int nEdges = 0;
        while (fileScanner.hasNext()) {
            fileScanner.nextLine();
            ++nEdges;
        }
        fileScanner.close();
        fileScanner = new Scanner(new FileReader(fileName));
        this.firstNeighborIndex = new int[nNodes + 1];
        this.totalEdgeWeightSelfLinks = 0.0;
        int[] neighbor = new int[nEdges];
        double[] edgeWeight2 = new double[nEdges];
        int i = 1;
        int nEdgesWithoutSelfLinks = 0;
        int j = 0;
        while (j < nEdges) {
            double edgeWeight;
            Scanner lineScanner = new Scanner(fileScanner.nextLine());
            int node1 = lineScanner.nextInt();
            int node2 = lineScanner.nextInt();
            double d = edgeWeight = lineScanner.hasNextDouble() ? lineScanner.nextDouble() : 1.0;
            if (node1 == node2) {
                this.totalEdgeWeightSelfLinks += edgeWeight;
            } else {
                if (node1 >= i) {
                    while (i <= node1) {
                        this.firstNeighborIndex[i] = nEdgesWithoutSelfLinks;
                        ++i;
                    }
                }
                neighbor[nEdgesWithoutSelfLinks] = node2;
                edgeWeight2[nEdgesWithoutSelfLinks] = edgeWeight;
                ++nEdgesWithoutSelfLinks;
            }
            ++j;
        }
        while (i <= nNodes) {
            this.firstNeighborIndex[i] = nEdgesWithoutSelfLinks;
            ++i;
        }
        this.neighbor = new int[nEdgesWithoutSelfLinks];
        System.arraycopy(neighbor, 0, this.neighbor, 0, nEdgesWithoutSelfLinks);
        this.edgeWeight = new double[nEdgesWithoutSelfLinks];
        System.arraycopy(edgeWeight2, 0, this.edgeWeight, 0, nEdgesWithoutSelfLinks);
        fileScanner.close();
        if (nodeWeight == null) {
            this.nodeWeight = new double[nNodes];
            i = 0;
            while (i < nNodes) {
                this.nodeWeight[i] = 1.0;
                ++i;
            }
        } else {
            this.nodeWeight = nodeWeight;
        }
        this.setClusters(cluster);
    }

    public Object clone() {
        try {
            Network clonedNetwork = (Network)super.clone();
            if (this.cluster != null) {
                clonedNetwork.cluster = (int[])this.cluster.clone();
            }
            clonedNetwork.deleteClusteringStats();
            return clonedNetwork;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void save(String fileName) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(fileName));
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }

    public int getNNodes() {
        return this.nNodes;
    }

    public int getNEdges() {
        return this.neighbor.length;
    }

    public int[][] getEdges() {
        int[][] edge = new int[this.neighbor.length][2];
        int i = 0;
        while (i < this.nNodes) {
            int j = this.firstNeighborIndex[i];
            while (j < this.firstNeighborIndex[i + 1]) {
                edge[j][0] = i;
                edge[j][1] = this.neighbor[j];
                ++j;
            }
            ++i;
        }
        return edge;
    }

    public double getTotalEdgeWeight() {
        double totalEdgeWeight = this.totalEdgeWeightSelfLinks;
        int i = 0;
        while (i < this.neighbor.length) {
            totalEdgeWeight += this.edgeWeight[i];
            ++i;
        }
        return totalEdgeWeight;
    }

    public double[] getEdgeWeights() {
        return this.edgeWeight;
    }

    public double getTotalNodeWeight() {
        double totalNodeWeight = 0.0;
        int i = 0;
        while (i < this.nNodes) {
            totalNodeWeight += this.nodeWeight[i];
            ++i;
        }
        return totalNodeWeight;
    }

    public double[] getNodeWeights() {
        return this.nodeWeight;
    }

    public int getNClusters() {
        return this.nClusters;
    }

    public int[] getClusters() {
        return this.cluster;
    }

    public double[] getClusterWeights() {
        if (this.cluster == null) {
            return null;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        return this.clusterWeight;
    }

    public int[] getNNodesPerCluster() {
        if (this.cluster == null) {
            return null;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        return this.nNodesPerCluster;
    }

    public int[][] getNodesPerCluster() {
        if (this.cluster == null) {
            return null;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        return this.nodePerCluster;
    }

    public void setClusters(int[] cluster) {
        if (cluster == null) {
            this.nClusters = 0;
        } else {
            int i = 0;
            int j = 0;
            while (j < this.nNodes) {
                if (cluster[j] > i) {
                    i = cluster[j];
                }
                ++j;
            }
            this.nClusters = i + 1;
        }
        this.cluster = cluster;
        this.deleteClusteringStats();
    }

    public void initSingletonClusters() {
        this.nClusters = this.nNodes;
        this.cluster = new int[this.nNodes];
        int i = 0;
        while (i < this.nNodes) {
            this.cluster[i] = i;
            ++i;
        }
        this.deleteClusteringStats();
    }

    public void findConnectedComponents() {
        this.cluster = new int[this.nNodes];
        int i = 0;
        while (i < this.nNodes) {
            this.cluster[i] = -1;
            ++i;
        }
        int[] node = new int[this.nNodes];
        int[] neighborIndex = new int[this.nNodes];
        this.nClusters = 0;
        i = 0;
        while (i < this.nNodes) {
            if (this.cluster[i] == -1) {
                this.cluster[i] = this.nClusters;
                node[0] = i;
                neighborIndex[0] = this.firstNeighborIndex[i];
                int j = 0;
                do {
                    if (neighborIndex[j] == this.firstNeighborIndex[node[j] + 1]) {
                        --j;
                        continue;
                    }
                    if (this.cluster[this.neighbor[neighborIndex[j]]] == -1) {
                        this.cluster[this.neighbor[neighborIndex[j]]] = this.nClusters;
                        node[j + 1] = this.neighbor[neighborIndex[j]];
                        neighborIndex[j + 1] = this.firstNeighborIndex[node[j + 1]];
                        int n = j++;
                        neighborIndex[n] = neighborIndex[n] + 1;
                        continue;
                    }
                    int n = j;
                    neighborIndex[n] = neighborIndex[n] + 1;
                } while (j >= 0);
                ++this.nClusters;
            }
            ++i;
        }
        this.deleteClusteringStats();
    }

    public void mergeClusters(int[] newCluster) {
        if (this.cluster == null) {
            return;
        }
        int i = 0;
        int j = 0;
        while (j < this.nNodes) {
            int k = newCluster[this.cluster[j]];
            if (k > i) {
                i = k;
            }
            this.cluster[j] = k;
            ++j;
        }
        this.nClusters = i + 1;
        this.deleteClusteringStats();
    }

    public boolean removeCluster(int cluster) {
        if (this.cluster == null) {
            return false;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        boolean removed = this.removeCluster2(cluster);
        this.deleteClusteringStats();
        return removed;
    }

    public void removeSmallClusters(double minClusterWeight) {
        int smallestCluster;
        if (this.cluster == null) {
            return;
        }
        Network reducedNetwork = this.getReducedNetwork();
        reducedNetwork.initSingletonClusters();
        reducedNetwork.calcClusteringStats();
        boolean[] ignore = new boolean[this.nClusters];
        do {
            smallestCluster = -1;
            double minClusterWeight2 = minClusterWeight;
            int i = 0;
            while (i < reducedNetwork.nClusters) {
                if (!ignore[i] && reducedNetwork.clusterWeight[i] < minClusterWeight2) {
                    smallestCluster = i;
                    minClusterWeight2 = reducedNetwork.clusterWeight[i];
                }
                ++i;
            }
            if (smallestCluster < 0) continue;
            reducedNetwork.removeCluster2(smallestCluster);
            ignore[smallestCluster] = true;
        } while (smallestCluster >= 0);
        this.mergeClusters(reducedNetwork.getClusters());
    }

    public void orderClustersByWeight() {
        this.orderClusters(true);
    }

    public void orderClustersByNNodes() {
        this.orderClusters(false);
    }

    public Network getSubnetwork(int cluster) {
        if (this.cluster == null) {
            return null;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        int[] subnetworkNode = new int[this.nNodes];
        int[] subnetworkNeighbor = new int[this.neighbor.length];
        double[] subnetworkEdgeWeight = new double[this.edgeWeight.length];
        return this.getSubnetwork(cluster, subnetworkNode, subnetworkNeighbor, subnetworkEdgeWeight);
    }

    public Network[] getSubnetworks() {
        if (this.cluster == null) {
            return null;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        Network[] subnetwork = new Network[this.nClusters];
        int[] subnetworkNode = new int[this.nNodes];
        int[] subnetworkNeighbor = new int[this.neighbor.length];
        double[] subnetworkEdgeWeight = new double[this.edgeWeight.length];
        int i = 0;
        while (i < this.nClusters) {
            subnetwork[i] = this.getSubnetwork(i, subnetworkNode, subnetworkNeighbor, subnetworkEdgeWeight);
            ++i;
        }
        return subnetwork;
    }

    public Network getReducedNetwork() {
        if (this.cluster == null) {
            return null;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        Network reducedNetwork = new Network();
        reducedNetwork.nNodes = this.nClusters;
        reducedNetwork.firstNeighborIndex = new int[this.nClusters + 1];
        reducedNetwork.totalEdgeWeightSelfLinks = this.totalEdgeWeightSelfLinks;
        reducedNetwork.nodeWeight = new double[this.nClusters];
        int[] reducedNetworkNeighbor1 = new int[this.neighbor.length];
        double[] reducedNetworkEdgeWeight1 = new double[this.edgeWeight.length];
        int[] reducedNetworkNeighbor2 = new int[this.nClusters - 1];
        double[] reducedNetworkEdgeWeight2 = new double[this.nClusters];
        int reducedNetworkNEdges1 = 0;
        int i = 0;
        while (i < this.nClusters) {
            int reducedNetworkNEdges2 = 0;
            int j = 0;
            while (j < this.nodePerCluster[i].length) {
                int k = this.nodePerCluster[i][j];
                int l = this.firstNeighborIndex[k];
                while (l < this.firstNeighborIndex[k + 1]) {
                    int m = this.cluster[this.neighbor[l]];
                    if (m != i) {
                        if (reducedNetworkEdgeWeight2[m] == 0.0) {
                            reducedNetworkNeighbor2[reducedNetworkNEdges2] = m;
                            ++reducedNetworkNEdges2;
                        }
                        int n = m;
                        reducedNetworkEdgeWeight2[n] = reducedNetworkEdgeWeight2[n] + this.edgeWeight[l];
                    } else {
                        reducedNetwork.totalEdgeWeightSelfLinks += this.edgeWeight[l];
                    }
                    ++l;
                }
                int n = i;
                reducedNetwork.nodeWeight[n] = reducedNetwork.nodeWeight[n] + this.nodeWeight[k];
                ++j;
            }
            j = 0;
            while (j < reducedNetworkNEdges2) {
                reducedNetworkNeighbor1[reducedNetworkNEdges1 + j] = reducedNetworkNeighbor2[j];
                reducedNetworkEdgeWeight1[reducedNetworkNEdges1 + j] = reducedNetworkEdgeWeight2[reducedNetworkNeighbor2[j]];
                reducedNetworkEdgeWeight2[reducedNetworkNeighbor2[j]] = 0.0;
                ++j;
            }
            reducedNetwork.firstNeighborIndex[i + 1] = reducedNetworkNEdges1 += reducedNetworkNEdges2;
            ++i;
        }
        reducedNetwork.neighbor = new int[reducedNetworkNEdges1];
        reducedNetwork.edgeWeight = new double[reducedNetworkNEdges1];
        System.arraycopy(reducedNetworkNeighbor1, 0, reducedNetwork.neighbor, 0, reducedNetworkNEdges1);
        System.arraycopy(reducedNetworkEdgeWeight1, 0, reducedNetwork.edgeWeight, 0, reducedNetworkNEdges1);
        return reducedNetwork;
    }

    public Network getLargestConnectedComponent() {
        Network clonedNetwork = (Network)this.clone();
        clonedNetwork.findConnectedComponents();
        clonedNetwork.calcClusteringStats();
        int largestCluster = -1;
        double maxClusterWeight = -1.0;
        int i = 0;
        while (i < clonedNetwork.nClusters) {
            if (clonedNetwork.clusterWeight[i] > maxClusterWeight) {
                largestCluster = i;
                maxClusterWeight = clonedNetwork.clusterWeight[i];
            }
            ++i;
        }
        return clonedNetwork.getSubnetwork(largestCluster);
    }

    public double calcQualityFunction(double resolution) {
        if (this.cluster == null) {
            return Double.NaN;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        double qualityFunction = this.totalEdgeWeightSelfLinks;
        double totalEdgeWeight = this.totalEdgeWeightSelfLinks;
        int i = 0;
        while (i < this.nNodes) {
            int j = this.cluster[i];
            int k = this.firstNeighborIndex[i];
            while (k < this.firstNeighborIndex[i + 1]) {
                if (this.cluster[this.neighbor[k]] == j) {
                    qualityFunction += this.edgeWeight[k];
                }
                totalEdgeWeight += this.edgeWeight[k];
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < this.nClusters) {
            qualityFunction -= this.clusterWeight[i] * this.clusterWeight[i] * resolution;
            ++i;
        }
        return qualityFunction /= totalEdgeWeight;
    }

    public boolean runLocalMovingAlgorithm(double resolution) {
        return this.runLocalMovingAlgorithm(resolution, new Random());
    }

    public boolean runLocalMovingAlgorithm(double resolution, Random random) {
        int k;
        int j;
        if (this.cluster == null || this.nNodes == 1) {
            return false;
        }
        boolean update = false;
        double[] clusterWeight = new double[this.nNodes];
        int[] nNodesPerCluster = new int[this.nNodes];
        int i = 0;
        while (i < this.nNodes) {
            int n = this.cluster[i];
            clusterWeight[n] = clusterWeight[n] + this.nodeWeight[i];
            int n2 = this.cluster[i];
            nNodesPerCluster[n2] = nNodesPerCluster[n2] + 1;
            ++i;
        }
        int nUnusedClusters = 0;
        int[] unusedCluster = new int[this.nNodes];
        i = 0;
        while (i < this.nNodes) {
            if (nNodesPerCluster[i] == 0) {
                unusedCluster[nUnusedClusters] = i;
                ++nUnusedClusters;
            }
            ++i;
        }
        int[] nodeOrder = new int[this.nNodes];
        i = 0;
        while (i < this.nNodes) {
            nodeOrder[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.nNodes) {
            j = random.nextInt(this.nNodes);
            k = nodeOrder[i];
            nodeOrder[i] = nodeOrder[j];
            nodeOrder[j] = k;
            ++i;
        }
        double[] edgeWeightPerCluster = new double[this.nNodes];
        int[] neighboringCluster = new int[this.nNodes - 1];
        int nStableNodes = 0;
        i = 0;
        do {
            int l;
            j = nodeOrder[i];
            int nNeighboringClusters = 0;
            k = this.firstNeighborIndex[j];
            while (k < this.firstNeighborIndex[j + 1]) {
                l = this.cluster[this.neighbor[k]];
                if (edgeWeightPerCluster[l] == 0.0) {
                    neighboringCluster[nNeighboringClusters] = l;
                    ++nNeighboringClusters;
                }
                int n = l;
                edgeWeightPerCluster[n] = edgeWeightPerCluster[n] + this.edgeWeight[k];
                ++k;
            }
            int n = this.cluster[j];
            clusterWeight[n] = clusterWeight[n] - this.nodeWeight[j];
            int n3 = this.cluster[j];
            nNodesPerCluster[n3] = nNodesPerCluster[n3] - 1;
            if (nNodesPerCluster[this.cluster[j]] == 0) {
                unusedCluster[nUnusedClusters] = this.cluster[j];
                ++nUnusedClusters;
            }
            int bestCluster = -1;
            double maxQualityFunction = 0.0;
            k = 0;
            while (k < nNeighboringClusters) {
                l = neighboringCluster[k];
                double qualityFunction = edgeWeightPerCluster[l] - this.nodeWeight[j] * clusterWeight[l] * resolution;
                if (qualityFunction > maxQualityFunction || qualityFunction == maxQualityFunction && l < bestCluster) {
                    bestCluster = l;
                    maxQualityFunction = qualityFunction;
                }
                edgeWeightPerCluster[l] = 0.0;
                ++k;
            }
            if (maxQualityFunction == 0.0) {
                bestCluster = unusedCluster[nUnusedClusters - 1];
                --nUnusedClusters;
            }
            int n4 = bestCluster;
            clusterWeight[n4] = clusterWeight[n4] + this.nodeWeight[j];
            int n5 = bestCluster;
            nNodesPerCluster[n5] = nNodesPerCluster[n5] + 1;
            if (bestCluster == this.cluster[j]) {
                ++nStableNodes;
            } else {
                this.cluster[j] = bestCluster;
                nStableNodes = 1;
                update = true;
            }
            int n6 = i = i < this.nNodes - 1 ? i + 1 : 0;
        } while (nStableNodes < this.nNodes);
        int[] newCluster = new int[this.nNodes];
        this.nClusters = 0;
        i = 0;
        while (i < this.nNodes) {
            if (nNodesPerCluster[i] > 0) {
                newCluster[i] = this.nClusters++;
            }
            ++i;
        }
        i = 0;
        while (i < this.nNodes) {
            this.cluster[i] = newCluster[this.cluster[i]];
            ++i;
        }
        this.deleteClusteringStats();
        return update;
    }

    public boolean runLouvainAlgorithm(double resolution) {
        return this.runLouvainAlgorithm(resolution, new Random());
    }

    public boolean runLouvainAlgorithm(double resolution, Random random) {
        if (this.cluster == null || this.nNodes == 1) {
            return false;
        }
        boolean update = this.runLocalMovingAlgorithm(resolution, random);
        if (this.nClusters < this.nNodes) {
            Network reducedNetwork = this.getReducedNetwork();
            reducedNetwork.initSingletonClusters();
            boolean update2 = reducedNetwork.runLouvainAlgorithm(resolution, random);
            if (update2) {
                update = true;
                this.mergeClusters(reducedNetwork.getClusters());
            }
        }
        this.deleteClusteringStats();
        return update;
    }

    public boolean runLouvainAlgorithmWithMultilevelRefinement(double resolution) {
        return this.runLouvainAlgorithmWithMultilevelRefinement(resolution, new Random());
    }

    public boolean runLouvainAlgorithmWithMultilevelRefinement(double resolution, Random random) {
        if (this.cluster == null || this.nNodes == 1) {
            return false;
        }
        boolean update = this.runLocalMovingAlgorithm(resolution, random);
        if (this.nClusters < this.nNodes) {
            Network reducedNetwork = this.getReducedNetwork();
            reducedNetwork.initSingletonClusters();
            boolean update2 = reducedNetwork.runLouvainAlgorithm(resolution, random);
            if (update2) {
                update = true;
                this.mergeClusters(reducedNetwork.getClusters());
                this.runLocalMovingAlgorithm(resolution, random);
            }
        }
        this.deleteClusteringStats();
        return update;
    }

    public boolean runSmartLocalMovingAlgorithm(double resolution) {
        return this.runSmartLocalMovingAlgorithm(resolution, new Random());
    }

    public boolean runSmartLocalMovingAlgorithm(double resolution, Random random) {
        if (this.cluster == null || this.nNodes == 1) {
            return false;
        }
        boolean update = this.runLocalMovingAlgorithm(resolution, random);
        if (this.nClusters < this.nNodes) {
            int j;
            if (!this.clusteringStatsAvailable) {
                this.calcClusteringStats();
            }
            Network[] subnetwork = this.getSubnetworks();
            this.nClusters = 0;
            int i = 0;
            while (i < subnetwork.length) {
                subnetwork[i].initSingletonClusters();
                subnetwork[i].runLocalMovingAlgorithm(resolution, random);
                int[] subnetworkCluster = subnetwork[i].getClusters();
                j = 0;
                while (j < subnetworkCluster.length) {
                    this.cluster[this.nodePerCluster[i][j]] = this.nClusters + subnetworkCluster[j];
                    ++j;
                }
                this.nClusters += subnetwork[i].getNClusters();
                ++i;
            }
            this.calcClusteringStats();
            Network reducedNetwork = this.getReducedNetwork();
            int[] reducedNetworkCluster = new int[this.nClusters];
            i = 0;
            j = 0;
            while (j < subnetwork.length) {
                int k = 0;
                while (k < subnetwork[j].getNClusters()) {
                    reducedNetworkCluster[i] = j;
                    ++i;
                    ++k;
                }
                ++j;
            }
            reducedNetwork.setClusters(reducedNetworkCluster);
            update |= reducedNetwork.runSmartLocalMovingAlgorithm(resolution, random);
            this.mergeClusters(reducedNetwork.getClusters());
        }
        this.deleteClusteringStats();
        return update;
    }

    private Network() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.deleteClusteringStats();
        out.defaultWriteObject();
    }

    private boolean removeCluster2(int cluster) {
        int j;
        double[] reducedNetworkEdgeWeight = new double[this.nClusters];
        int i = 0;
        while (i < this.nNodes) {
            if (this.cluster[i] == cluster) {
                j = this.firstNeighborIndex[i];
                while (j < this.firstNeighborIndex[i + 1]) {
                    int n = this.cluster[this.neighbor[j]];
                    reducedNetworkEdgeWeight[n] = reducedNetworkEdgeWeight[n] + this.edgeWeight[j];
                    ++j;
                }
            }
            ++i;
        }
        int bestCluster = -1;
        double maxQualityFunction = 0.0;
        i = 0;
        while (i < this.nClusters) {
            double qualityFunction;
            if (i != cluster && this.clusterWeight[i] > 0.0 && (qualityFunction = reducedNetworkEdgeWeight[i] / this.clusterWeight[i]) > maxQualityFunction) {
                bestCluster = i;
                maxQualityFunction = qualityFunction;
            }
            ++i;
        }
        if (bestCluster == -1) {
            return false;
        }
        i = 0;
        while (i < this.nNodes) {
            if (this.cluster[i] == cluster) {
                this.cluster[i] = bestCluster;
            }
            ++i;
        }
        int n = bestCluster;
        this.clusterWeight[n] = this.clusterWeight[n] + this.clusterWeight[cluster];
        this.clusterWeight[cluster] = 0.0;
        if (cluster == this.nClusters - 1) {
            i = 0;
            j = 0;
            while (j < this.nNodes) {
                if (this.cluster[j] > i) {
                    i = this.cluster[j];
                }
                ++j;
            }
            this.nClusters = i + 1;
        }
        return true;
    }

    private void orderClusters(boolean orderByWeight) {
        if (this.cluster == null) {
            return;
        }
        if (!this.clusteringStatsAvailable) {
            this.calcClusteringStats();
        }
        class ClusterSize
        implements Comparable<ClusterSize> {
            public int cluster;
            public double size;

            public ClusterSize(int cluster, double size) {
                this.cluster = cluster;
                this.size = size;
            }

            @Override
            public int compareTo(ClusterSize cluster) {
                return cluster.size > this.size ? 1 : (cluster.size < this.size ? -1 : 0);
            }
        }
        Object[] clusterSize = new ClusterSize[this.nClusters];
        int i = 0;
        while (i < this.nClusters) {
            clusterSize[i] = new ClusterSize(i, orderByWeight ? this.clusterWeight[i] : (double)this.nNodesPerCluster[i]);
            ++i;
        }
        Arrays.sort(clusterSize);
        int[] newCluster = new int[this.nClusters];
        i = 0;
        do {
            newCluster[((ClusterSize)clusterSize[i]).cluster] = i;
        } while (++i < this.nClusters && ((ClusterSize)clusterSize[i]).size > 0.0);
        this.nClusters = i;
        i = 0;
        while (i < this.nNodes) {
            this.cluster[i] = newCluster[this.cluster[i]];
            ++i;
        }
        this.deleteClusteringStats();
    }

    private Network getSubnetwork(int cluster, int[] subnetworkNode, int[] subnetworkNeighbor, double[] subnetworkEdgeWeight) {
        int subnetworkNNodes;
        Network subnetwork = new Network();
        subnetwork.nNodes = subnetworkNNodes = this.nodePerCluster[cluster].length;
        if (subnetworkNNodes == 1) {
            subnetwork.firstNeighborIndex = new int[2];
            subnetwork.neighbor = new int[0];
            subnetwork.edgeWeight = new double[0];
            subnetwork.nodeWeight = new double[]{this.nodeWeight[this.nodePerCluster[cluster][0]]};
        } else {
            int i = 0;
            while (i < this.nodePerCluster[cluster].length) {
                subnetworkNode[this.nodePerCluster[cluster][i]] = i;
                ++i;
            }
            subnetwork.firstNeighborIndex = new int[subnetworkNNodes + 1];
            subnetwork.nodeWeight = new double[subnetworkNNodes];
            int subnetworkNEdges = 0;
            i = 0;
            while (i < subnetworkNNodes) {
                int j = this.nodePerCluster[cluster][i];
                int k = this.firstNeighborIndex[j];
                while (k < this.firstNeighborIndex[j + 1]) {
                    if (this.cluster[this.neighbor[k]] == cluster) {
                        subnetworkNeighbor[subnetworkNEdges] = subnetworkNode[this.neighbor[k]];
                        subnetworkEdgeWeight[subnetworkNEdges] = this.edgeWeight[k];
                        ++subnetworkNEdges;
                    }
                    ++k;
                }
                subnetwork.firstNeighborIndex[i + 1] = subnetworkNEdges;
                subnetwork.nodeWeight[i] = this.nodeWeight[j];
                ++i;
            }
            subnetwork.neighbor = new int[subnetworkNEdges];
            subnetwork.edgeWeight = new double[subnetworkNEdges];
            System.arraycopy(subnetworkNeighbor, 0, subnetwork.neighbor, 0, subnetworkNEdges);
            System.arraycopy(subnetworkEdgeWeight, 0, subnetwork.edgeWeight, 0, subnetworkNEdges);
        }
        subnetwork.totalEdgeWeightSelfLinks = 0.0;
        return subnetwork;
    }

    private void calcClusteringStats() {
        this.clusterWeight = new double[this.nClusters];
        this.nNodesPerCluster = new int[this.nClusters];
        this.nodePerCluster = new int[this.nClusters][];
        int i = 0;
        while (i < this.nNodes) {
            int n = this.cluster[i];
            this.clusterWeight[n] = this.clusterWeight[n] + this.nodeWeight[i];
            int n2 = this.cluster[i];
            this.nNodesPerCluster[n2] = this.nNodesPerCluster[n2] + 1;
            ++i;
        }
        i = 0;
        while (i < this.nClusters) {
            this.nodePerCluster[i] = new int[this.nNodesPerCluster[i]];
            this.nNodesPerCluster[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.nNodes) {
            int j = this.cluster[i];
            this.nodePerCluster[j][this.nNodesPerCluster[j]] = i++;
            int n = j;
            this.nNodesPerCluster[n] = this.nNodesPerCluster[n] + 1;
        }
        this.clusteringStatsAvailable = true;
    }

    private void deleteClusteringStats() {
        this.clusterWeight = null;
        this.nNodesPerCluster = null;
        this.nodePerCluster = null;
        this.clusteringStatsAvailable = false;
    }
}

