/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.dichotomize;

import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.util.TableIterator;

public class Dichotomize
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;

    public Dichotomize(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() {
        Graph graph = (Graph)this.data[0].getData();
        String attribute = (String)this.parameters.get("attribute");
        String comparator = (String)this.parameters.get("comparator");
        double cutoff = (Double)this.parameters.get("cutoff");
        Table nodeTable = graph.getNodeTable().getSchema().instantiate();
        Table edgeTable = graph.getEdgeTable().getSchema().instantiate();
        TableIterator nodes = graph.getNodeTable().iterator();
        while (nodes.hasNext()) {
            nodeTable.addTuple(graph.getNodeTable().getTuple(((Integer)nodes.next()).intValue()));
        }
        TableIterator edges = graph.getEdgeTable().iterator();
        while (edges.hasNext()) {
            Tuple tuple = graph.getEdgeTable().getTuple(((Integer)edges.next()).intValue());
            Object value = tuple.get(attribute);
            if (value == null || !this.passes(comparator, ((Number)value).doubleValue(), cutoff)) continue;
            edgeTable.addTuple(tuple);
        }
        Graph resultGraph = new Graph(nodeTable, edgeTable, graph.isDirected(), graph.getNodeKeyField(), graph.getEdgeSourceField(), graph.getEdgeTargetField());
        BasicData result = new BasicData((Object)resultGraph, Graph.class.getName());
        Dictionary metadata = result.getMetadata();
        metadata.put("Label", "Only edges with " + attribute + " " + comparator + " " + cutoff);
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Network");
        return new Data[]{result};
    }

    private boolean passes(String comparator, double value, double cutoff) {
        if (">=".equals(comparator)) {
            return value >= cutoff;
        }
        if (">".equals(comparator)) {
            return value > cutoff;
        }
        return true;
    }
}

