/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractcoauthorship.algorithms;

import edu.iu.nwb.analysis.extractcoauthorship.metadata.SupportedFileTypes;
import edu.iu.nwb.analysis.extractnetfromtable.components.ExtractNetworkFromTable;
import edu.iu.nwb.analysis.extractnetfromtable.components.GraphContainer;
import edu.iu.nwb.analysis.extractnetfromtable.components.InvalidColumnNameException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Graph;
import prefuse.data.Table;

public class ExtractAlgorithm
implements Algorithm,
SupportedFileTypes,
ProgressTrackable {
    Data[] data;
    Dictionary parameters;
    CIShellContext ciContext;
    LogService logger;
    ProgressMonitor progressMonitor;

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    public ExtractAlgorithm(Data[] dm, Dictionary parameters, CIShellContext cContext) {
        this.data = dm;
        this.parameters = parameters;
        this.ciContext = cContext;
        this.logger = (LogService)this.ciContext.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table dataTable = (Table)this.data[0].getData();
        String fileFormat = this.parameters.get("fileFormat").toString();
        String fileFormatPropertiesFile = this.getFileTypeProperties(fileFormat);
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream fileTypePropertiesFile = loader.getResourceAsStream(fileFormatPropertiesFile);
        Properties metaData = new Properties();
        try {
            metaData.load(fileTypePropertiesFile);
        }
        catch (FileNotFoundException fnfe) {
            this.logger.log(1, fnfe.getMessage(), (Throwable)fnfe);
        }
        catch (IOException ie) {
            this.logger.log(1, ie.getMessage(), (Throwable)ie);
        }
        try {
            String authorColumn = SupportedFileTypes.CitationFormat.getAuthorColumnByName(fileFormat);
            GraphContainer gc = GraphContainer.initializeGraph((Table)dataTable, (String)authorColumn, (String)authorColumn, (boolean)false, (Properties)metaData, (LogService)this.logger, (ProgressMonitor)this.progressMonitor);
            Graph outputGraph = gc.buildGraph(authorColumn, authorColumn, "|", false, this.logger);
            BasicData outputData1 = new BasicData((Object)outputGraph, Graph.class.getName());
            Dictionary graphAttributes = outputData1.getMetadata();
            graphAttributes.put("Modified", new Boolean(true));
            graphAttributes.put("Parent", this.data[0]);
            graphAttributes.put("Type", "Network");
            graphAttributes.put("Label", "Extracted Co-Authorship Network");
            Table outputTable = ExtractNetworkFromTable.constructTable((Graph)outputGraph);
            BasicData outputData2 = new BasicData((Object)outputTable, Table.class.getName());
            Dictionary tableAttributes = outputData2.getMetadata();
            tableAttributes.put("Modified", new Boolean(true));
            tableAttributes.put("Parent", this.data[0]);
            tableAttributes.put("Type", "Matrix");
            tableAttributes.put("Label", "Author information");
            return new Data[]{outputData1, outputData2};
        }
        catch (InvalidColumnNameException ex) {
            throw new AlgorithmExecutionException(ex.getMessage(), (Throwable)ex);
        }
        catch (GraphContainer.PropertyParsingException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
    }

    private String getFileTypeProperties(String fileType) {
        String propertiesFileName = "/edu/iu/nwb/analysis/extractcoauthorship/metadata/";
        return String.valueOf(propertiesFileName) + fileType + ".properties";
    }
}

