/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractcoauthorship.algorithms;

import edu.iu.nwb.analysis.extractcoauthorship.algorithms.ExtractAlgorithm;
import edu.iu.nwb.analysis.extractcoauthorship.metadata.SupportedFileTypes;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ExtractAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator,
SupportedFileTypes {
    private MetaTypeInformation originalProvider;
    private String pid;

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        BasicObjectClassDefinition definition;
        ObjectClassDefinition oldDefinition = this.originalProvider.getObjectClassDefinition(this.pid, null);
        try {
            definition = new BasicObjectClassDefinition(oldDefinition.getID(), oldDefinition.getName(), oldDefinition.getDescription(), oldDefinition.getIcon(16));
        }
        catch (IOException iOException) {
            definition = new BasicObjectClassDefinition(oldDefinition.getID(), oldDefinition.getName(), oldDefinition.getDescription(), null);
        }
        String[] supportedFormats = SupportedFileTypes.supportedFormats;
        definition.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition("fileFormat", "File Format", "The file format of the original data.", 1, supportedFormats, supportedFormats));
        return definition;
    }

    protected void activate(ComponentContext ctxt) {
        MetaTypeService mts = (MetaTypeService)ctxt.locateService("MTS");
        this.originalProvider = mts.getMetaTypeInformation(ctxt.getBundleContext().getBundle());
        this.pid = (String)ctxt.getServiceReference().getProperty("service.pid");
    }

    protected void deactivate(ComponentContext ctxt) {
        this.originalProvider = null;
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new ExtractAlgorithm(data, parameters, context);
    }
}

