/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractcoauthorship.metadata;

import java.util.HashMap;

public interface SupportedFileTypes {
    public static final CitationFormat bibtex = new CitationFormat("bibtex", "author");
    public static final CitationFormat isi = new CitationFormat("isi", "Authors");
    public static final CitationFormat scopus = new CitationFormat("scopus", "Authors");
    public static final CitationFormat endnote = new CitationFormat("endnote", "Authors");
    public static final String[] supportedFormats = CitationFormat.getSupportedFormats();

    public static class CitationFormat {
        private static HashMap nameToColumn = new HashMap();

        public CitationFormat(String name, String authorColumn) {
            nameToColumn.put(name, authorColumn);
        }

        public static String getAuthorColumnByName(String name) {
            return nameToColumn.get(name).toString();
        }

        public static String[] getSupportedFormats() {
            String[] supportedFormats = new String[nameToColumn.size()];
            supportedFormats = nameToColumn.keySet().toArray(supportedFormats);
            return supportedFormats;
        }
    }
}

