/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractdirectednetfromtable;

import edu.iu.nwb.analysis.extractnetfromtable.components.GraphContainer;
import edu.iu.nwb.analysis.extractnetfromtable.components.InvalidColumnNameException;
import edu.iu.nwb.analysis.extractnetfromtable.components.PropertyHandler;
import java.util.Dictionary;
import java.util.Properties;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.framework.data.Data;
import org.cishell.utilities.BasicDataPlus;
import org.osgi.service.log.LogService;
import prefuse.data.Graph;
import prefuse.data.Table;

public class ExtractNetworkAlgorithm
implements Algorithm,
ProgressTrackable {
    public static final String CSV_MIME_TYPE = "file:text/csv";
    private Data[] data;
    private boolean isBipartite;
    private String outDataLabel;
    private String sourceColumnName;
    private String targetColumnName;
    private String delimiter;
    private Object aggregationFunctionFilePath;
    private LogService logger;
    private ProgressMonitor progressMonitor;

    public ExtractNetworkAlgorithm(Data[] data, Dictionary parameters, CIShellContext context, boolean isBipartite, String outDataLabel) {
        this.data = data;
        this.isBipartite = isBipartite;
        this.outDataLabel = outDataLabel;
        this.sourceColumnName = (String)parameters.get("sourceColumn");
        this.targetColumnName = (String)parameters.get("targetColumn");
        this.delimiter = (String)parameters.get("delimiter");
        this.aggregationFunctionFilePath = parameters.get("aff");
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table dataTable = (Table)this.data[0].getData();
        Properties functions = null;
        if (this.aggregationFunctionFilePath != null) {
            functions = PropertyHandler.getProperties((String)this.aggregationFunctionFilePath.toString(), (LogService)this.logger);
        }
        try {
            GraphContainer graphContainer = GraphContainer.initializeGraph((Table)dataTable, (String)this.sourceColumnName, (String)this.targetColumnName, (boolean)true, (Properties)functions, (LogService)this.logger, (ProgressMonitor)this.progressMonitor);
            Graph network = graphContainer.buildGraph(this.sourceColumnName, this.targetColumnName, this.delimiter, this.isBipartite, this.logger);
            BasicDataPlus outData = new BasicDataPlus((Object)network, this.data[0]);
            outData.markAsModified();
            outData.setType("Network");
            outData.setLabel(this.outDataLabel);
            return new Data[]{outData};
        }
        catch (InvalidColumnNameException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (GraphContainer.PropertyParsingException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }
}

