package edu.iu.nwb.analysis.extractnetfromtable.components;

/* The point of this class is to maintain backwards compatibility
 * after adding Extract Bipartite Network.  See the equals method.
 */
public class NodeID {
	private String label;
	private String bipartiteType;

	public NodeID(String label, String type) {
		this.label = label;
		this.bipartiteType = type;
	}

	/* We expect that these NodeID objects will always have bipartiteType = null when we are not
	 * performing Extract Bipartite Network, and so node equality will continue to be determined
	 * (as it had been) solely by equality of labels.
	 * 
	 * Code generated by Eclipse.
	 */
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		
		if (obj == null) {
			return false;
		}
		
		if (!(obj instanceof NodeID)) {
			return false;
		}
		
		NodeID other = (NodeID) obj;	
		
		if (label == null) {
			if (other.label != null) {
				return false;
			}
		} else if (!label.equals(other.label)) {
			return false;
		}
		
		if (bipartiteType == null) {
			if (other.bipartiteType != null) {
				return false;
			}
		} else if (!bipartiteType.equals(other.bipartiteType)) {
			return false;
		}
		
		return true;
	}
	// Code generated by Eclipse.
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((bipartiteType == null) ? 0 : bipartiteType.hashCode());
		result = prime * result + ((label == null) ? 0 : label.hashCode());
		return result;
	}
}