/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.aggregate;

import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AbstractAggregateFunction;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionName;

public class ArithmeticMeanFunctionFactory
implements AggregateFunctionFactory {
    private static final AggregateFunctionName TYPE = AggregateFunctionName.ARITHMETICMEAN;

    @Override
    public AbstractAggregateFunction getFunction(Class c) {
        if (c.equals(Integer.TYPE) || c.equals(Integer.class) || c.equals(Integer[].class) || c.equals(int[].class)) {
            return new DoubleArithmeticMean();
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class) || c.equals(Double[].class) || c.equals(double[].class)) {
            return new DoubleArithmeticMean();
        }
        if (c.equals(Float.TYPE) || c.equals(Float.class) || c.equals(Float[].class) || c.equals(float[].class)) {
            return new FloatArithmeticMean();
        }
        return null;
    }

    @Override
    public AggregateFunctionName getType() {
        return TYPE;
    }

    class DoubleArithmeticMean
    extends AbstractAggregateFunction {
        private double total = 0.0;
        private long items = 0L;

        @Override
        public Double getResult() {
            return new Double(this.total / (double)this.items);
        }

        @Override
        public Class<Double> getType() {
            return Double.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                ++this.items;
                this.total += ((Number)object).doubleValue();
            } else {
                throw new IllegalArgumentException("DoubleArithmeticMean can only operate on Numbers.");
            }
        }

        @Override
        protected Double cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return DoubleArithmeticMean.cleanDoublePrefuseBug(object);
        }
    }

    class FloatArithmeticMean
    extends AbstractAggregateFunction {
        private float total = 0.0f;
        private long items = 0L;

        @Override
        public Float getResult() {
            return new Float(this.total / (float)this.items);
        }

        @Override
        public Class<Float> getType() {
            return Float.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                ++this.items;
                this.total += ((Number)object).floatValue();
            } else {
                throw new IllegalArgumentException("FloatArithmeticMean can only operate on Numbers.");
            }
        }

        @Override
        protected Float cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return FloatArithmeticMean.cleanFloatPrefuseBug(object);
        }
    }
}

