/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.aggregate;

import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AbstractAggregateFunction;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionName;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.ArithmeticMeanFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.CountFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.GeometricMeanFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.MaxFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.MinFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.ModeFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.SumFunctionFactory;
import java.util.HashMap;
import java.util.Set;

public class AssembleAggregateFunctions {
    private HashMap<AggregateFunctionName, AggregateFunctionFactory> nameToFunctionFactory = new HashMap();

    public static AssembleAggregateFunctions defaultAssembly() {
        AssembleAggregateFunctions aaf = new AssembleAggregateFunctions();
        aaf.putAggregateFunctionFactory(AggregateFunctionName.ARITHMETICMEAN, new ArithmeticMeanFunctionFactory());
        aaf.putAggregateFunctionFactory(AggregateFunctionName.COUNT, new CountFunctionFactory());
        aaf.putAggregateFunctionFactory(AggregateFunctionName.GEOMETRICMEAN, new GeometricMeanFunctionFactory());
        aaf.putAggregateFunctionFactory(AggregateFunctionName.MAX, new MaxFunctionFactory());
        aaf.putAggregateFunctionFactory(AggregateFunctionName.MIN, new MinFunctionFactory());
        aaf.putAggregateFunctionFactory(AggregateFunctionName.SUM, new SumFunctionFactory());
        aaf.putAggregateFunctionFactory(AggregateFunctionName.MODE, new ModeFunctionFactory());
        return aaf;
    }

    public AbstractAggregateFunction getAggregateFunction(AggregateFunctionName function, Class type) {
        AbstractAggregateFunction af = null;
        try {
            af = this.nameToFunctionFactory.get((Object)function).getFunction(type);
        }
        catch (NullPointerException nullPointerException) {
            af = null;
        }
        return af;
    }

    public AggregateFunctionFactory putAggregateFunctionFactory(AggregateFunctionName name, AggregateFunctionFactory aggregationFunctionFactory) {
        if (this.nameToFunctionFactory.get((Object)name) != null) {
            return null;
        }
        this.nameToFunctionFactory.put(name, aggregationFunctionFactory);
        return aggregationFunctionFactory;
    }

    public AggregateFunctionFactory removeAggregateFunctionFactory(String functionName) {
        return this.nameToFunctionFactory.get(functionName);
    }

    public Set<AggregateFunctionName> getFunctionNames() {
        return this.nameToFunctionFactory.keySet();
    }
}

