/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.aggregate;

import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AbstractAggregateFunction;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionName;

public class GeometricMeanFunctionFactory
implements AggregateFunctionFactory {
    private static final AggregateFunctionName TYPE = AggregateFunctionName.GEOMETRICMEAN;

    @Override
    public AbstractAggregateFunction getFunction(Class c) {
        if (c.equals(Integer.TYPE) || c.equals(Integer.class) || c.equals(int[].class) || c.equals(Integer[].class)) {
            return new DoubleGeometricMean();
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class) || c.equals(double[].class) || c.equals(Double[].class)) {
            return new DoubleGeometricMean();
        }
        if (c.equals(Float.TYPE) || c.equals(Float.class) || c.equals(float[].class) || c.equals(Float[].class)) {
            return new FloatGeometricMean();
        }
        return null;
    }

    @Override
    public AggregateFunctionName getType() {
        return TYPE;
    }

    class DoubleGeometricMean
    extends AbstractAggregateFunction {
        private double value = 1.0;
        private long items = 0L;

        @Override
        public Object getResult() {
            double result = Math.pow(this.value, 1.0 / (double)this.items);
            return result;
        }

        @Override
        public Class getType() {
            return Double.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                ++this.items;
                this.value *= ((Number)object).doubleValue();
            } else {
                throw new IllegalArgumentException("DoubleGeometricMean can only operate on Numbers.");
            }
        }

        @Override
        protected Double cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return DoubleGeometricMean.cleanDoublePrefuseBug(object);
        }
    }

    class FloatGeometricMean
    extends AbstractAggregateFunction {
        private float value = 1.0f;
        private long items = 0L;

        @Override
        public Object getResult() {
            float result = (float)Math.pow(this.value, 1.0f / (float)this.items);
            return Float.valueOf(result);
        }

        @Override
        public Class getType() {
            return Float.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                ++this.items;
                this.value *= ((Number)object).floatValue();
            } else {
                throw new IllegalArgumentException("FloatArithmeticMean can only operate on Numbers.");
            }
        }

        @Override
        protected Float cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return FloatGeometricMean.cleanFloatPrefuseBug(object);
        }
    }
}

