/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.aggregate;

import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AbstractAggregateFunction;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionName;

public class MinFunctionFactory
implements AggregateFunctionFactory {
    private static final AggregateFunctionName TYPE = AggregateFunctionName.MIN;

    @Override
    public AggregateFunctionName getType() {
        return TYPE;
    }

    @Override
    public AbstractAggregateFunction getFunction(Class c) {
        if (c.equals(Integer.TYPE) || c.equals(Integer.class) || c.equals(int[].class) || c.equals(Integer[].class)) {
            return new IntegerMin();
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class) || c.equals(double[].class) || c.equals(Double[].class)) {
            return new DoubleMin();
        }
        if (c.equals(Float.TYPE) || c.equals(Float.class) || c.equals(float[].class) || c.equals(Float[].class)) {
            return new FloatMin();
        }
        return null;
    }

    class DoubleMin
    extends AbstractAggregateFunction {
        private double value = Double.MAX_VALUE;

        @Override
        public Object getResult() {
            return new Double(this.value);
        }

        @Override
        public Class getType() {
            return Double.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                if (((Number)object).doubleValue() < this.value) {
                    this.value = ((Number)object).doubleValue();
                }
            } else {
                throw new IllegalArgumentException("DoubleMin can only operate on Numbers.");
            }
        }

        @Override
        protected Double cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return DoubleMin.cleanDoublePrefuseBug(object);
        }
    }

    class FloatMin
    extends AbstractAggregateFunction {
        private float value = Float.MAX_VALUE;

        @Override
        public Object getResult() {
            return new Float(this.value);
        }

        @Override
        public Class getType() {
            return Float.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                if (((Number)object).floatValue() < this.value) {
                    this.value = ((Number)object).floatValue();
                }
            } else {
                throw new IllegalArgumentException("FloatMin can only operate on Numbers.");
            }
        }

        @Override
        protected Float cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return FloatMin.cleanFloatPrefuseBug(object);
        }
    }

    class IntegerMin
    extends AbstractAggregateFunction {
        private int value = Integer.MAX_VALUE;

        @Override
        public Object getResult() {
            return this.value;
        }

        @Override
        public Class getType() {
            return Integer.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                if (((Number)object).intValue() < this.value) {
                    this.value = ((Number)object).intValue();
                }
            } else {
                throw new IllegalArgumentException("IntegerMin can only operate on Numbers.");
            }
        }

        @Override
        protected Integer cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return IntegerMin.cleanIntegerPrefuseBug(object);
        }
    }
}

