/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.aggregate;

import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AbstractAggregateFunction;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionName;
import java.util.HashMap;
import java.util.Map;

public class ModeFunctionFactory
implements AggregateFunctionFactory {
    private static final AggregateFunctionName TYPE = AggregateFunctionName.MODE;

    @Override
    public AbstractAggregateFunction getFunction(Class c) {
        if (Integer.TYPE.equals(c) || Integer.class.equals((Object)c) || int[].class.equals((Object)c) || Integer[].class.equals((Object)c)) {
            return new IntegerMode();
        }
        if (Boolean.TYPE.equals(c) || Boolean.class.equals((Object)c) || boolean[].class.equals((Object)c) || Boolean[].class.equals((Object)c)) {
            return new BooleanMode();
        }
        return new StringMode();
    }

    @Override
    public AggregateFunctionName getType() {
        return TYPE;
    }

    private static abstract class AbstractModeFunction
    extends AbstractAggregateFunction {
        private Map<Object, Integer> objectToOccurrences = new HashMap<Object, Integer>();

        @Override
        public Object getResult() {
            return AbstractModeFunction.findKeyWithMaxValue(this.objectToOccurrences);
        }

        @Override
        public void innerOperate(Object object) {
            if (!this.objectToOccurrences.containsKey(object)) {
                this.objectToOccurrences.put(object, 0);
            }
            Integer oldNumberOfOccurrences = this.objectToOccurrences.get(object);
            this.objectToOccurrences.put(object, oldNumberOfOccurrences + 1);
        }

        private static Object findKeyWithMaxValue(Map<Object, Integer> map) {
            Object maxKey = null;
            Integer maxValue = Integer.MIN_VALUE;
            for (Map.Entry<Object, Integer> numericEntry : map.entrySet()) {
                Integer value = numericEntry.getValue();
                if (value < maxValue) continue;
                maxKey = numericEntry.getKey();
                maxValue = value;
            }
            return maxKey;
        }
    }

    class BooleanMode
    extends AbstractModeFunction {
        BooleanMode() {
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }

        @Override
        protected Boolean cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return BooleanMode.cleanBooleanPrefuseBug(object);
        }
    }

    class IntegerMode
    extends AbstractModeFunction {
        IntegerMode() {
        }

        @Override
        public Class getType() {
            return Integer.class;
        }

        @Override
        protected Integer cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return IntegerMode.cleanIntegerPrefuseBug(object);
        }
    }

    class StringMode
    extends AbstractModeFunction {
        StringMode() {
        }

        @Override
        public Class getType() {
            return String.class;
        }

        @Override
        protected String cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return StringMode.cleanStringPrefuseBug(object);
        }
    }
}

