/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.aggregate;

import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AbstractAggregateFunction;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionFactory;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionName;

public class SumFunctionFactory
implements AggregateFunctionFactory {
    private static final AggregateFunctionName TYPE = AggregateFunctionName.SUM;

    @Override
    public AbstractAggregateFunction getFunction(Class c) {
        if (c.equals(Integer.TYPE) || c.equals(Integer.class) || c.equals(int[].class) || c.equals(Integer[].class)) {
            return new IntegerSum();
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class) || c.equals(double[].class) || c.equals(Double[].class)) {
            return new DoubleSum();
        }
        if (c.equals(Float.TYPE) || c.equals(Float.class) || c.equals(float[].class) || c.equals(Float[].class)) {
            return new FloatSum();
        }
        return null;
    }

    @Override
    public AggregateFunctionName getType() {
        return TYPE;
    }

    class DoubleSum
    extends AbstractAggregateFunction {
        private double total = 0.0;

        @Override
        public Double getResult() {
            return this.total;
        }

        @Override
        public Class getType() {
            return Double.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                this.total += ((Number)object).doubleValue();
            } else {
                throw new IllegalArgumentException("DoubleSum can only operate on Numbers.");
            }
        }

        @Override
        protected Double cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return DoubleSum.cleanDoublePrefuseBug(object);
        }
    }

    class FloatSum
    extends AbstractAggregateFunction {
        private float total = 0.0f;

        @Override
        public Float getResult() {
            return Float.valueOf(this.total);
        }

        @Override
        public Class getType() {
            return Float.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                this.total += ((Number)object).floatValue();
            } else {
                throw new IllegalArgumentException("FloatSum can only operate on Numbers.");
            }
        }

        @Override
        protected Float cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return FloatSum.cleanFloatPrefuseBug(object);
        }
    }

    class IntegerSum
    extends AbstractAggregateFunction {
        private int total = 0;

        @Override
        public Integer getResult() {
            return this.total;
        }

        @Override
        public Class getType() {
            return Integer.class;
        }

        @Override
        protected void innerOperate(Object object) {
            if (object instanceof Number) {
                this.total += ((Number)object).intValue();
            } else {
                throw new IllegalArgumentException("IntegerSum can only operate on Numbers.");
            }
        }

        @Override
        protected Integer cleanPrefuseIssue(Object object) throws AbstractAggregateFunction.ObjectCouldNotBeCleanedException {
            return IntegerSum.cleanIntegerPrefuseBug(object);
        }
    }
}

