/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.algorithms;

import edu.iu.nwb.analysis.extractnetfromtable.components.ExtractNetworkFromTable;
import edu.iu.nwb.analysis.extractnetfromtable.components.GraphContainer;
import edu.iu.nwb.analysis.extractnetfromtable.components.InvalidColumnNameException;
import edu.iu.nwb.analysis.extractnetfromtable.components.PropertyHandler;
import java.util.Dictionary;
import java.util.Properties;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.cishell.utilities.DataFactory;
import org.osgi.service.log.LogService;
import prefuse.data.Graph;
import prefuse.data.Table;

public class ExtractNetFromTableAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary<String, Object> parameters;
    private LogService logger;

    public ExtractNetFromTableAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table dataTable = (Table)this.data[0].getData();
        String delimiter = (String)this.parameters.get("delimiter");
        String extractColumn = (String)this.parameters.get("columnName");
        Properties properties = null;
        Object aggregationFunctionFilePath = this.parameters.get("aggregationFunctionFile");
        if (aggregationFunctionFilePath != null) {
            properties = PropertyHandler.getProperties((String)aggregationFunctionFilePath, this.logger);
        }
        Graph graph = this.getGraph(dataTable, delimiter, extractColumn, properties);
        Table mergeTable = ExtractNetworkFromTable.constructTable(graph);
        Data outGraphData = this.createOutGraphData(extractColumn, graph);
        Data outTableData = this.createOutTableData(extractColumn, mergeTable);
        return new Data[]{outGraphData, outTableData};
    }

    private Graph getGraph(Table dataTable, String delimiter, String extractColumn, Properties properties) throws AlgorithmExecutionException {
        try {
            GraphContainer graphContainer = GraphContainer.initializeGraph(dataTable, extractColumn, extractColumn, false, properties, this.logger);
            Graph graph = graphContainer.buildGraph(extractColumn, extractColumn, delimiter, false, this.logger);
            return graph;
        }
        catch (InvalidColumnNameException e) {
            String message = "Invalid column name: " + e.getMessage();
            throw new AlgorithmExecutionException(message, (Throwable)e);
        }
        catch (GraphContainer.PropertyParsingException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
    }

    private Data createOutGraphData(String extractColumn, Graph outputGraph) {
        Data outData = DataFactory.withClassNameAsFormat((Object)outputGraph, (String)"Network", (Data)this.data[0], (String)("Extracted Network on Column " + extractColumn));
        outData.getMetadata().put("Modified", true);
        return outData;
    }

    private Data createOutTableData(String extractColumn, Table table) {
        Data outData = DataFactory.withClassNameAsFormat((Object)table, (String)"Matrix", (Data)this.data[0], (String)("Merge Table: based on " + extractColumn));
        outData.getMetadata().put("Modified", true);
        return outData;
    }
}

