/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.components;

import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AbstractAggregateFunction;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AggregateFunctionName;
import edu.iu.nwb.analysis.extractnetfromtable.aggregate.AssembleAggregateFunctions;
import edu.iu.nwb.analysis.extractnetfromtable.components.ValueAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.osgi.service.log.LogService;
import prefuse.data.Schema;

public class AggregateFunctionMappings {
    private final HashMap<String, AggregateFunctionName> metaColumnNameToFunctionMap = new HashMap();
    private final HashMap<String, String> functionColumnToOriginalColumnMap = new HashMap();
    private final HashMap<String, Integer> functionColumnToAppliedNodeTypeMap = new HashMap();
    private final HashMap<Object, ValueAttributes> labelToFunctionMap = new HashMap();
    public static final int SOURCE_AND_TARGET = 0;
    public static final int SOURCE = 1;
    public static final int TARGET = 2;
    public static final String DEFAULT_WEIGHT_NAME = "weight";

    public void addFunctionMapping(String functionValueCol, String originalCol, AggregateFunctionName function) {
        this.metaColumnNameToFunctionMap.put(functionValueCol, function);
        this.functionColumnToOriginalColumnMap.put(functionValueCol, originalCol);
        this.functionColumnToAppliedNodeTypeMap.put(functionValueCol, new Integer(0));
    }

    public void addFunctionMapping(String functionValueCol, String originalCol, AggregateFunctionName functionType, int nodeType) {
        this.metaColumnNameToFunctionMap.put(functionValueCol, functionType);
        this.functionColumnToOriginalColumnMap.put(functionValueCol, originalCol);
        this.functionColumnToAppliedNodeTypeMap.put(functionValueCol, new Integer(nodeType));
    }

    public ValueAttributes addFunctionRow(Object id, ValueAttributes va) {
        this.labelToFunctionMap.put(id, va);
        return va;
    }

    public AggregateFunctionName getFunctionFromColumnName(String columnName) {
        return this.metaColumnNameToFunctionMap.get(columnName);
    }

    public String getOriginalColumnFromFunctionColumn(String columnName) {
        return this.functionColumnToOriginalColumnMap.get(columnName);
    }

    public ValueAttributes getFunctionRow(Object id) {
        return this.labelToFunctionMap.get(id);
    }

    public int getAppliedNodeType(String columnName) {
        return this.functionColumnToAppliedNodeTypeMap.get(columnName);
    }

    public static void parseProperties(Schema input, Schema nodes, Schema edges, Properties properties, AggregateFunctionMappings nodeFunctionMappings, AggregateFunctionMappings edgeFunctionMappings, LogService log) throws CompatibleAggregationNotFoundException {
        if (properties != null) {
            HashSet<AggregateFunctionName> functionNames = new HashSet<AggregateFunctionName>(AssembleAggregateFunctions.defaultAssembly().getFunctionNames());
            HashSet<String> columnNames = new HashSet<String>();
            int i = 0;
            while (i < input.getColumnCount()) {
                columnNames.add(input.getColumnName(i));
                ++i;
            }
            for (String string : properties.keySet()) {
                String[] functionDefinitionLHS = string.split("\\.");
                String[] functionDefinitionRHS = properties.getProperty(string).split("\\.");
                String applyToNodeType = null;
                int nodeType = -1;
                String sourceColumnName = functionDefinitionRHS[0];
                Class columnType = input.getColumnType(sourceColumnName);
                AggregateFunctionName function = AggregateFunctionName.fromString(functionDefinitionRHS[functionDefinitionRHS.length - 1]);
                if (functionDefinitionRHS.length == 3) {
                    applyToNodeType = functionDefinitionRHS[1];
                }
                nodeType = applyToNodeType == null ? 0 : ("source".equalsIgnoreCase(applyToNodeType) ? 1 : ("target".equalsIgnoreCase(applyToNodeType) ? 2 : 0));
                String newColumnName = functionDefinitionLHS[functionDefinitionLHS.length - 1];
                if (functionNames.contains((Object)function) && columnNames.contains(sourceColumnName) && !columnNames.contains(newColumnName)) {
                    if (string.startsWith("edge.")) {
                        if (!AggregateFunctionMappings.createColumn(newColumnName, function, columnType, edges)) {
                            throw new CompatibleAggregationNotFoundException(String.format("Trying to make column '%s', could not find an aggregation function %s that applies to column type %s", new Object[]{newColumnName, function, columnType.getName()}));
                        }
                        edgeFunctionMappings.addFunctionMapping(newColumnName, sourceColumnName, function);
                    }
                    if (string.startsWith("node.")) {
                        if (!AggregateFunctionMappings.createColumn(newColumnName, function, columnType, nodes)) {
                            throw new CompatibleAggregationNotFoundException(String.format("Trying to make column '%s', could not find an aggregation function %s that applies to column type %s", new Object[]{newColumnName, function, columnType.getName()}));
                        }
                        nodeFunctionMappings.addFunctionMapping(newColumnName, sourceColumnName, function, nodeType);
                    }
                }
                if (!functionNames.contains((Object)function)) {
                    log.log(2, "Unrecognized function: " + (Object)((Object)function) + ".\nContinuing with " + "extraction, but ignoring this specific analysis.");
                }
                if (!columnNames.contains(sourceColumnName)) {
                    log.log(2, "Unrecognized column: " + sourceColumnName + ".\nContinuing with " + "extraction, but ignoring this specific analysis.");
                }
                if (!columnNames.contains(newColumnName)) continue;
                log.log(2, "The column: " + newColumnName + " already exists." + "\nContinuing with " + "extraction, but ignoring this specific analysis.");
            }
        }
    }

    public static void addDefaultEdgeWeightColumn(Schema inputGraphNodeSchema, Schema outputGraphEdgeSchema, AggregateFunctionMappings edgeFunctionMappings, String sourceColumnName) throws CompatibleAggregationNotFoundException {
        String newColumnName = DEFAULT_WEIGHT_NAME;
        AggregateFunctionName function = AggregateFunctionName.COUNT;
        Class columnType = inputGraphNodeSchema.getColumnType(sourceColumnName);
        if (!AggregateFunctionMappings.createColumn(newColumnName, function, columnType, outputGraphEdgeSchema)) {
            throw new CompatibleAggregationNotFoundException(String.format("Trying to make column '%s', could not find an aggregation function %s that applies to column type %s", new Object[]{newColumnName, function, columnType.getName()}));
        }
        edgeFunctionMappings.addFunctionMapping(newColumnName, sourceColumnName, function);
    }

    private static boolean createColumn(String newColumnName, AggregateFunctionName function, Class columnType, Schema newSchema) {
        AbstractAggregateFunction aggFunc = AssembleAggregateFunctions.defaultAssembly().getAggregateFunction(function, columnType);
        if (aggFunc == null) {
            return false;
        }
        Class finalType = aggFunc.getType();
        newSchema.addColumn(newColumnName, finalType);
        return true;
    }

    public static class CompatibleAggregationNotFoundException
    extends Exception {
        private static final long serialVersionUID = 7588826870075190310L;

        public CompatibleAggregationNotFoundException() {
        }

        public CompatibleAggregationNotFoundException(String message) {
            super(message);
        }

        public CompatibleAggregationNotFoundException(Throwable cause) {
            super(cause);
        }

        public CompatibleAggregationNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

