/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.components;

import edu.iu.nwb.analysis.extractnetfromtable.components.AggregateFunctionMappings;
import edu.iu.nwb.analysis.extractnetfromtable.components.FunctionContainer;
import edu.iu.nwb.analysis.extractnetfromtable.components.ValueAttributes;
import java.util.TreeSet;
import java.util.Vector;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class EdgeContainer {
    boolean hasSkippedColumns = false;

    private void createEdge(Vector edgeVector, Graph graph, Table table, int rowNumber, AggregateFunctionMappings afm) {
        if (!graph.isDirected()) {
            Integer src = new Integer(((Node)edgeVector.get(0)).getRow());
            Integer tgt = new Integer(((Node)edgeVector.get(1)).getRow());
            TreeSet<Integer> edgeSet = new TreeSet<Integer>();
            edgeSet.add(src);
            edgeSet.add(tgt);
            edgeVector.set(0, graph.getNode(((Integer)edgeSet.first()).intValue()));
            edgeVector.set(1, graph.getNode(((Integer)edgeSet.last()).intValue()));
        }
        Node source = (Node)edgeVector.get(0);
        Node target = (Node)edgeVector.get(1);
        Edge edge = graph.addEdge(source, target);
        ValueAttributes va = new ValueAttributes(edge.getRow());
        FunctionContainer functionContainer = new FunctionContainer();
        va = functionContainer.mutateFunctions((Tuple)edge, table, rowNumber, va, afm, 0);
        if (functionContainer.hasSkippedColumns) {
            this.hasSkippedColumns = true;
            functionContainer.hasSkippedColumns = false;
        }
        afm.addFunctionRow(edgeVector, va);
    }

    void mutateEdge(Node source, Node target, Graph graph, Table table, int rowNumber, AggregateFunctionMappings afm) {
        if (source == null || target == null) {
            return;
        }
        Vector<Node> edgeVector = new Vector<Node>(2);
        if (!graph.isDirected()) {
            Integer src = new Integer(source.getRow());
            Integer tgt = new Integer(target.getRow());
            TreeSet<Integer> edgeSet = new TreeSet<Integer>();
            edgeSet.add(src);
            edgeSet.add(tgt);
            edgeVector.add(graph.getNode(((Integer)edgeSet.first()).intValue()));
            edgeVector.add(graph.getNode(((Integer)edgeSet.last()).intValue()));
        } else {
            edgeVector.add(source);
            edgeVector.add(target);
        }
        ValueAttributes va = afm.getFunctionRow(edgeVector);
        if (va == null) {
            this.createEdge(edgeVector, graph, table, rowNumber, afm);
        } else {
            int edgeNumber = va.getRowNumber();
            FunctionContainer functionContainer = new FunctionContainer();
            functionContainer.mutateFunctions((Tuple)graph.getEdge(edgeNumber), table, rowNumber, va, afm, 0);
            if (functionContainer.hasSkippedColumns) {
                this.hasSkippedColumns = true;
                functionContainer.hasSkippedColumns = false;
            }
        }
    }
}

