/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.components;

import java.util.Iterator;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;

public class ExtractNetworkFromTable {
    public static Table constructTable(Graph graph) {
        Table outputTable = new Table();
        outputTable = ExtractNetworkFromTable.createTableSchema(graph.getNodeTable().getSchema(), outputTable);
        outputTable = ExtractNetworkFromTable.populateTable(outputTable, graph);
        return outputTable;
    }

    private static Table createTableSchema(Schema graphSchema, Table t) {
        int i = 0;
        while (i < graphSchema.getColumnCount()) {
            t.addColumn(graphSchema.getColumnName(i), graphSchema.getColumnType(i));
            ++i;
        }
        t.addColumn("uniqueIndex", Integer.class);
        t.addColumn("combineValues", String.class, (Object)"*");
        return t;
    }

    private static Table populateTable(Table t, Graph g) {
        Iterator it = g.nodes();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            t.addRow();
            int i = 0;
            while (i < n.getColumnCount()) {
                t.set(t.getRowCount() - 1, i, n.get(i));
                ++i;
            }
            t.set(t.getRowCount() - 1, "uniqueIndex", (Object)new Integer(t.getRowCount()));
        }
        return t;
    }
}

